/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.SimpleExecutionCallback;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMultiTargetMessageTask<P>
extends AbstractMessageTask<P> {
    private static final int TRY_COUNT = 100;

    protected AbstractMultiTargetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() throws Throwable {
        OperationFactory operationFactory = this.createOperationFactory();
        Collection<Address> targets = this.getTargets();
        this.returnResponseIfNoTargetLeft(targets, Collections.EMPTY_MAP);
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        MultiTargetCallback callback = new MultiTargetCallback(targets);
        for (Address target : targets) {
            Operation op = operationFactory.createOperation();
            InvocationBuilder builder = operationService.createInvocationBuilder(this.getServiceName(), op, target).setTryCount(100).setResultDeserialized(false).setExecutionCallback(new SingleTargetCallback(target, callback));
            builder.invoke();
        }
    }

    private void returnResponseIfNoTargetLeft(Collection<Address> targets, Map<Address, Object> results) throws Throwable {
        if (targets.isEmpty()) {
            this.sendResponse(this.reduce(results));
        }
    }

    protected abstract OperationFactory createOperationFactory();

    protected abstract Object reduce(Map<Address, Object> var1) throws Throwable;

    public abstract Collection<Address> getTargets();

    private final class SingleTargetCallback
    extends SimpleExecutionCallback<Object> {
        final Address target;
        final MultiTargetCallback parent;

        private SingleTargetCallback(Address target, MultiTargetCallback parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void notify(Object object) {
            this.parent.notify(this.target, object);
        }
    }

    private final class MultiTargetCallback {
        final Collection<Address> targets;
        final Map<Address, Object> results;

        private MultiTargetCallback(Collection<Address> targets) {
            this.targets = Collections.synchronizedSet(new HashSet<Address>(targets));
            this.results = new ConcurrentHashMap<Address, Object>(targets.size());
        }

        public void notify(Address target, Object result) {
            if (!this.targets.remove(target)) {
                if (this.results.containsKey(target)) {
                    throw new IllegalArgumentException("Duplicate response from -> " + target);
                }
                throw new IllegalArgumentException("Unknown target! -> " + target);
            }
            this.results.put(target, result);
            try {
                AbstractMultiTargetMessageTask.this.returnResponseIfNoTargetLeft(this.targets, this.results);
            }
            catch (Throwable throwable) {
                AbstractMultiTargetMessageTask.this.handleProcessingFailure(throwable);
            }
        }
    }
}

