/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.nearcache.StaleReadPreventerNearCacheWrapper;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NearCachedMapProxyImpl<K, V>
extends MapProxyImpl<K, V> {
    protected NearCache<Data, Object> nearCache;
    protected KeyStateMarker keyStateMarker;
    protected boolean cacheLocalEntries;

    public NearCachedMapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine, MapConfig mapConfig) {
        super(name, mapService, nodeEngine, mapConfig);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.init();
    }

    protected void init() {
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        this.nearCache = nearCacheProvider.getOrCreateNearCache(this.name);
        this.keyStateMarker = this.getKeyStateMarker();
        this.cacheLocalEntries = this.getMapConfig().getNearCacheConfig().isCacheLocalEntries();
    }

    @Override
    protected Object getInternal(Data key) {
        Object value = this.getCachedValue(key);
        if (value != null) {
            if (this.isCachedNull(value)) {
                return null;
            }
            return value;
        }
        boolean marked = this.keyStateMarker.tryMark(key);
        value = super.getInternal(key);
        if (marked) {
            this.tryToPutNearCache(key, value);
        }
        return value;
    }

    private void tryToPutNearCache(Data key, Object value) {
        try {
            if (!this.isOwn(key) || this.cacheLocalEntries) {
                this.nearCache.put(key, value);
            }
        }
        finally {
            if (!this.keyStateMarker.tryUnmark(key)) {
                this.invalidateCache(key);
                this.keyStateMarker.forceUnmark(key);
            }
        }
    }

    @Override
    protected ICompletableFuture<Data> getAsyncInternal(final Data key) {
        Object value = this.nearCache.get(key);
        if (value != null) {
            if (this.isCachedNull(value)) {
                value = null;
            }
            return new CompletedFuture<Data>(this.getNodeEngine().getSerializationService(), value, this.getNodeEngine().getExecutionService().getExecutor("hz:async"));
        }
        final boolean marked = this.keyStateMarker.tryMark(key);
        ICompletableFuture<Data> future = super.getAsyncInternal(key);
        future.andThen(new ExecutionCallback<Data>(){

            @Override
            public void onResponse(Data response) {
                if (marked) {
                    NearCachedMapProxyImpl.this.tryToPutNearCache(key, response);
                }
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    protected boolean isCachedNull(Object value) {
        return NearCache.NULL_OBJECT.equals(value);
    }

    @Override
    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        Data data = super.putInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        boolean putInternal = super.tryPutInternal(key, value, timeout, timeunit);
        this.invalidateCache(key);
        return putInternal;
    }

    @Override
    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        Data data = super.putIfAbsentInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        this.invalidateCache(key);
        super.putTransientInternal(key, value, ttl, timeunit);
    }

    @Override
    protected ICompletableFuture<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        ICompletableFuture<Data> future = super.putAsyncInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return future;
    }

    @Override
    protected ICompletableFuture<Data> setAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        ICompletableFuture<Data> future = super.setAsyncInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return future;
    }

    @Override
    protected boolean replaceInternal(Data key, Data expect, Data update) {
        boolean replaceInternal = super.replaceInternal(key, expect, update);
        this.invalidateCache(key);
        return replaceInternal;
    }

    @Override
    protected Data replaceInternal(Data key, Data value) {
        Data replaceInternal = super.replaceInternal(key, value);
        this.invalidateCache(key);
        return replaceInternal;
    }

    @Override
    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        super.setInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
    }

    @Override
    protected boolean evictInternal(Data key) {
        boolean evictInternal = super.evictInternal(key);
        this.invalidateCache(key);
        return evictInternal;
    }

    @Override
    protected void evictAllInternal() {
        super.evictAllInternal();
        this.nearCache.clear();
    }

    @Override
    public void clearInternal() {
        super.clearInternal();
        this.nearCache.clear();
    }

    @Override
    public void loadAllInternal(boolean replaceExistingValues) {
        super.loadAllInternal(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    @Override
    protected void loadInternal(Iterable<Data> keys, boolean replaceExistingValues) {
        super.loadInternal(keys, replaceExistingValues);
        this.invalidateCache(keys);
    }

    @Override
    protected Data removeInternal(Data key) {
        Data data = super.removeInternal(key);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected void deleteInternal(Data key) {
        super.deleteInternal(key);
        this.invalidateCache(key);
    }

    @Override
    protected boolean removeInternal(Data key, Data value) {
        boolean removeInternal = super.removeInternal(key, value);
        this.invalidateCache(key);
        return removeInternal;
    }

    @Override
    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        boolean removeInternal = super.tryRemoveInternal(key, timeout, timeunit);
        this.invalidateCache(key);
        return removeInternal;
    }

    @Override
    protected ICompletableFuture<Data> removeAsyncInternal(Data key) {
        this.invalidateCache(key);
        return super.removeAsyncInternal(key);
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get(keyData);
        if (cached != null) {
            return !this.isCachedNull(cached);
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected void getAllObjectInternal(List<Data> keys, List<Object> resultingKeyValuePairs) {
        this.getCachedValue(keys, resultingKeyValuePairs);
        Map<Data, Boolean> keyStates = MapUtil.createHashMap(keys.size());
        for (Data key : keys) {
            keyStates.put(key, this.keyStateMarker.tryMark(key));
        }
        int currentSize = resultingKeyValuePairs.size();
        super.getAllObjectInternal(keys, resultingKeyValuePairs);
        int i = currentSize;
        while (i < resultingKeyValuePairs.size()) {
            Data key = this.toData(resultingKeyValuePairs.get(i++));
            Data value = this.toData(resultingKeyValuePairs.get(i++));
            boolean marked = keyStates.remove(key);
            if (!marked) continue;
            this.tryToPutNearCache(key, value);
        }
        this.unmarkRemainingMarkedKeys(keyStates);
    }

    private void unmarkRemainingMarkedKeys(Map<Data, Boolean> markers) {
        for (Map.Entry<Data, Boolean> entry : markers.entrySet()) {
            Boolean marked = entry.getValue();
            if (!marked.booleanValue()) continue;
            this.keyStateMarker.forceUnmark(entry.getKey());
        }
    }

    @Override
    protected void invokePutAllOperationFactory(Address address, long size, int[] partitions, MapEntries[] entries) throws Exception {
        super.invokePutAllOperationFactory(address, size, partitions, entries);
        for (MapEntries mapEntries : entries) {
            for (int i = 0; i < mapEntries.size(); ++i) {
                this.invalidateCache(mapEntries.getKey(i));
            }
        }
    }

    @Override
    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        Data data = super.executeOnKeyInternal(key, entryProcessor);
        this.invalidateCache(key);
        return data;
    }

    @Override
    public Map executeOnKeysInternal(Set<Data> keys, EntryProcessor entryProcessor) {
        Map map = super.executeOnKeysInternal((Set)keys, entryProcessor);
        this.invalidateCache((Collection<Data>)keys);
        return map;
    }

    @Override
    public ICompletableFuture executeOnKeyInternal(Data key, EntryProcessor entryProcessor, ExecutionCallback<Object> callback) {
        ICompletableFuture future = super.executeOnKeyInternal(key, entryProcessor, (ExecutionCallback)callback);
        this.invalidateCache(key);
        return future;
    }

    @Override
    public void executeOnEntriesInternal(EntryProcessor entryProcessor, Predicate predicate, List<Data> resultingKeyValuePairs) {
        super.executeOnEntriesInternal(entryProcessor, predicate, (List)resultingKeyValuePairs);
        for (int i = 0; i < resultingKeyValuePairs.size(); i += 2) {
            Data key = resultingKeyValuePairs.get(i);
            this.invalidateCache(key);
        }
    }

    protected Object getCachedValue(Data key) {
        Object cached = this.nearCache.get(key);
        if (cached == null) {
            return null;
        }
        this.mapServiceContext.interceptAfterGet(this.name, cached);
        return cached;
    }

    protected void getCachedValue(List<Data> keys, List<Object> resultingKeyValuePairs) {
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Object value = this.getCachedValue(key);
            if (value == null) continue;
            if (!this.isCachedNull(value)) {
                resultingKeyValuePairs.add(this.toObject(key));
                resultingKeyValuePairs.add(this.toObject(value));
            }
            iterator.remove();
        }
    }

    protected void invalidateCache(Data key) {
        if (key != null) {
            this.nearCache.remove(key);
        }
    }

    protected void invalidateCache(Collection<Data> keys) {
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    protected void invalidateCache(Iterable<Data> keys) {
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    protected boolean isOwn(Data key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionService.getPartitionOwner(partitionId).equals(this.thisAddress);
    }

    public NearCache getNearCache() {
        return this.nearCache;
    }

    public KeyStateMarker getKeyStateMarker() {
        return ((StaleReadPreventerNearCacheWrapper)this.nearCache).getKeyStateMarker();
    }
}

