/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction.impl;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.util.StringUtil;

public final class EvictionConfigHelper {
    private EvictionConfigHelper() {
    }

    public static void checkEvictionConfig(EvictionConfig evictionConfig) {
        if (evictionConfig == null) {
            throw new IllegalArgumentException("Eviction config cannot be null!");
        }
        EvictionConfigHelper.checkEvictionConfig(evictionConfig.getEvictionPolicy(), evictionConfig.getComparatorClassName(), evictionConfig.getComparator());
    }

    public static void checkEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        if (comparatorClassName != null && comparator != null) {
            throw new IllegalArgumentException("Only one of the `comparator class name` and `comparator` can be configured in the eviction configuration!");
        }
        if (evictionPolicy == null || evictionPolicy == EvictionPolicy.NONE || evictionPolicy == EvictionPolicy.RANDOM) {
            if (StringUtil.isNullOrEmpty(comparatorClassName) && comparator == null) {
                throw new IllegalArgumentException("Eviction policy must be set to an eviction policy type rather than `null`, `NONE`, `RANDOM` or custom eviction policy comparator must be specified!");
            }
        } else if (evictionPolicy != EvictionConfig.DEFAULT_EVICTION_POLICY) {
            if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
                throw new IllegalArgumentException("Only one of the `eviction policy` and `comparator class name` can be configured!");
            }
            if (comparator != null) {
                throw new IllegalArgumentException("Only one of the `eviction policy` and `comparator` can be configured!");
            }
        }
    }
}

