/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.core.Member;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ConfigCheck;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.JoinRequest;
import com.hazelcast.internal.cluster.impl.MulticastJoiner;
import com.hazelcast.internal.cluster.impl.MulticastListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.util.Set;

public class NodeMulticastListener
implements MulticastListener {
    private final Node node;
    private final Set<String> trustedInterfaces;
    private final ILogger logger;
    private ConfigCheck ourConfig;

    public NodeMulticastListener(Node node) {
        this.node = node;
        this.trustedInterfaces = node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().getTrustedInterfaces();
        this.logger = node.getLogger(NodeMulticastListener.class.getName());
        this.ourConfig = node.createConfigCheck();
    }

    @Override
    public void onMessage(Object msg) {
        if (!this.isValidJoinMessage(msg)) {
            this.logDroppedMessage(msg);
            return;
        }
        JoinMessage joinMessage = (JoinMessage)msg;
        if (this.node.isRunning() && this.node.joined()) {
            this.handleActiveAndJoined(joinMessage);
        } else {
            this.handleNotActiveOrNotJoined(joinMessage);
        }
    }

    private void logDroppedMessage(Object msg) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Dropped: " + msg);
        }
    }

    private void handleActiveAndJoined(JoinMessage joinMessage) {
        if (!(joinMessage instanceof JoinRequest)) {
            this.logDroppedMessage(joinMessage);
            return;
        }
        if (this.node.isMaster()) {
            JoinMessage response = new JoinMessage(4, this.node.getBuildInfo().getBuildNumber(), this.node.getThisAddress(), this.node.localMember.getUuid(), this.node.isLiteMember(), this.node.createConfigCheck());
            this.node.multicastService.send(response);
        } else if (this.isMasterNode(joinMessage.getAddress()) && !this.checkMasterUuid(joinMessage.getUuid())) {
            String message = "New join request has been received from current master. Removing " + this.node.getMasterAddress();
            this.logger.warning(message);
            this.node.getClusterService().removeAddress(this.node.getMasterAddress(), message);
        }
    }

    private void handleNotActiveOrNotJoined(JoinMessage joinMessage) {
        if (this.isJoinRequest(joinMessage)) {
            Joiner joiner = this.node.getJoiner();
            if (joiner instanceof MulticastJoiner) {
                MulticastJoiner multicastJoiner = (MulticastJoiner)joiner;
                multicastJoiner.onReceivedJoinRequest((JoinRequest)joinMessage);
            } else {
                this.logDroppedMessage(joinMessage);
            }
        } else {
            Address address = joinMessage.getAddress();
            if (this.node.getJoiner().isBlacklisted(address)) {
                this.logDroppedMessage(joinMessage);
                return;
            }
            if (!this.node.joined() && this.node.getMasterAddress() == null) {
                String masterHost = joinMessage.getAddress().getHost();
                if (this.trustedInterfaces.isEmpty() || AddressUtil.matchAnyInterface(masterHost, this.trustedInterfaces)) {
                    Address masterAddress = new Address(joinMessage.getAddress());
                    this.node.setMasterAddress(masterAddress);
                } else {
                    this.logJoinMessageDropped(masterHost);
                }
            } else {
                this.logDroppedMessage(joinMessage);
            }
        }
    }

    private boolean isJoinRequest(JoinMessage joinMessage) {
        return joinMessage instanceof JoinRequest;
    }

    private void logJoinMessageDropped(String masterHost) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("JoinMessage from %s is dropped because its sender is not a trusted interface", masterHost));
        }
    }

    private boolean isJoinMessage(Object msg) {
        return msg != null && msg instanceof JoinMessage;
    }

    private boolean isValidJoinMessage(Object msg) {
        if (!this.isJoinMessage(msg)) {
            return false;
        }
        JoinMessage joinMessage = (JoinMessage)msg;
        if (this.isMessageToSelf(joinMessage)) {
            return false;
        }
        ConfigCheck theirConfig = joinMessage.getConfigCheck();
        return this.ourConfig.isSameGroup(theirConfig);
    }

    private boolean isMessageToSelf(JoinMessage joinMessage) {
        Address thisAddress = this.node.getThisAddress();
        return thisAddress == null || thisAddress.equals(joinMessage.getAddress());
    }

    private boolean isMasterNode(Address address) {
        return address.equals(this.node.getMasterAddress());
    }

    private boolean checkMasterUuid(String uuid) {
        Member masterMember = this.getMasterMember(this.node.getClusterService().getMembers());
        return masterMember == null || masterMember.getUuid().equals(uuid);
    }

    private Member getMasterMember(Set<Member> members) {
        if (members.isEmpty()) {
            return null;
        }
        return members.iterator().next();
    }
}

