/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.task.cache.AbstractCacheMessageTask;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.LegacyCacheConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.properties.GroupProperty;
import java.security.Permission;

public class CacheCreateConfigMessageTask
extends AbstractCacheMessageTask<CacheCreateConfigCodec.RequestParameters> {
    public CacheCreateConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        CacheConfig cacheConfig = this.extractCacheConfigFromMessage();
        return new CacheCreateConfigOperation(cacheConfig, ((CacheCreateConfigCodec.RequestParameters)this.parameters).createAlsoOnOthers);
    }

    private CacheConfig extractCacheConfigFromMessage() {
        boolean compatibilityEnabled;
        int clientVersion = this.getClientVersion();
        Object cacheConfig = null;
        if (-1 == clientVersion && (compatibilityEnabled = this.nodeEngine.getProperties().getBoolean(GroupProperty.COMPATIBILITY_3_6_CLIENT_ENABLED))) {
            LegacyCacheConfig legacyCacheConfig = (LegacyCacheConfig)this.nodeEngine.toObject(((CacheCreateConfigCodec.RequestParameters)this.parameters).cacheConfig, LegacyCacheConfig.class);
            if (null == legacyCacheConfig) {
                return null;
            }
            return legacyCacheConfig.getConfigAndReset();
        }
        return (CacheConfig)this.nodeEngine.toObject(((CacheCreateConfigCodec.RequestParameters)this.parameters).cacheConfig);
    }

    @Override
    protected CacheCreateConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheCreateConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        Data responseData = this.serializeCacheConfig(response);
        return CacheCreateConfigCodec.encodeResponse(responseData);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

