/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.ClientEvent;
import com.hazelcast.client.ClientEventType;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.client.impl.ClientHeartbeatMonitor;
import com.hazelcast.client.impl.CompositeMessageTaskFactory;
import com.hazelcast.client.impl.operations.ClientDisconnectionOperation;
import com.hazelcast.client.impl.operations.GetConnectedClientsOperation;
import com.hazelcast.client.impl.operations.PostJoinClientOperation;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.task.AuthenticationCustomCredentialsMessageTask;
import com.hazelcast.client.impl.protocol.task.AuthenticationMessageTask;
import com.hazelcast.client.impl.protocol.task.GetPartitionsMessageTask;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.client.impl.protocol.task.PingMessageTask;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.util.executor.ExecutorType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
CoreService,
PostJoinAwareService,
ManagedService,
MembershipAwareService,
EventPublishingService<ClientEvent, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    public static final int ENDPOINT_REMOVE_DELAY_SECONDS = 10;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_CORE = 100000;
    private static final int THREADS_PER_CORE = 20;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final SerializationService serializationService;
    private final ConcurrentMap<String, String> ownershipMappings = new ConcurrentHashMap<String, String>();
    private final ClientEndpointManagerImpl endpointManager;
    private final ILogger logger;
    private final ConnectionListener connectionListener = new ConnectionListenerImpl();
    private final MessageTaskFactory messageTaskFactory;
    private final ClientExceptionFactory clientExceptionFactory;

    public ClientEngineImpl(Node node) {
        this.logger = node.getLogger(ClientEngine.class);
        this.node = node;
        this.serializationService = node.getSerializationService();
        this.nodeEngine = node.nodeEngine;
        this.endpointManager = new ClientEndpointManagerImpl(this, this.nodeEngine);
        this.executor = this.newExecutor();
        this.messageTaskFactory = new CompositeMessageTaskFactory(this.nodeEngine);
        this.clientExceptionFactory = this.initClientExceptionFactory();
        ClientHeartbeatMonitor heartbeatMonitor = new ClientHeartbeatMonitor(this.endpointManager, this, this.nodeEngine.getExecutionService(), node.getProperties());
        heartbeatMonitor.start();
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jcacheAvailable = JCacheDetector.isJcacheAvailable(this.nodeEngine.getConfigClassLoader());
        return new ClientExceptionFactory(jcacheAvailable);
    }

    private Executor newExecutor() {
        InternalExecutionService executionService = this.nodeEngine.getExecutionService();
        int coreSize = Runtime.getRuntime().availableProcessors();
        int threadCount = this.node.getProperties().getInteger(GroupProperty.CLIENT_ENGINE_THREAD_COUNT);
        if (threadCount <= 0) {
            threadCount = coreSize * 20;
        }
        return executionService.register("hz:client", threadCount, coreSize * 100000, ExecutorType.CONCRETE);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpointManager.size();
    }

    public void handleClientMessage(ClientMessage clientMessage, Connection connection) {
        int partitionId = clientMessage.getPartitionId();
        MessageTask messageTask = this.messageTaskFactory.create(clientMessage, connection);
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        if (partitionId < 0) {
            if (this.isUrgent(messageTask)) {
                operationService.execute(new PriorityPartitionSpecificRunnable(messageTask));
            } else {
                this.executor.execute(messageTask);
            }
        } else {
            operationService.execute(messageTask);
        }
    }

    private boolean isUrgent(MessageTask messageTask) {
        Class<?> clazz = messageTask.getClass();
        return clazz == PingMessageTask.class || clazz == GetPartitionsMessageTask.class || clazz == AuthenticationMessageTask.class || clazz == AuthenticationCustomCredentialsMessageTask.class;
    }

    @Override
    public IPartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    public ClientEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public ClientExceptionFactory getClientExceptionFactory() {
        return this.clientExceptionFactory;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    public void bind(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (conn instanceof TcpIpConnection) {
            Address address = new Address(conn.getRemoteSocketAddress());
            ((TcpIpConnection)conn).setEndPoint(address);
        }
        ClientEvent event = new ClientEvent(endpoint.getUuid(), ClientEventType.CONNECTED, endpoint.getSocketAddress(), endpoint.getClientType());
        this.sendClientEvent(event);
    }

    void sendClientEvent(ClientEvent event) {
        InternalEventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> regs = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        String uuid = event.getUuid();
        eventService.publishEvent(SERVICE_NAME, regs, (Object)event, uuid.hashCode());
    }

    @Override
    public void dispatchEvent(ClientEvent event, ClientListener listener) {
        if (event.getEventType() == ClientEventType.CONNECTED) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        block3: {
            if (event.getMember().localMember()) {
                return;
            }
            String deadMemberUuid = event.getMember().getUuid();
            try {
                this.nodeEngine.getExecutionService().schedule(new DestroyEndpointTask(deadMemberUuid), 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block3;
                this.logger.finest(e);
            }
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public Collection<Client> getClients() {
        HashSet<Client> clients = new HashSet<Client>();
        for (ClientEndpoint endpoint : this.endpointManager.getEndpoints()) {
            clients.add(endpoint);
        }
        return clients;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.node.getConnectionManager().addConnectionListener(this.connectionListener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        for (ClientEndpoint ce : this.endpointManager.getEndpoints()) {
            ClientEndpointImpl endpoint = (ClientEndpointImpl)ce;
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                Connection conn = endpoint.getConnection();
                if (!conn.isAlive()) continue;
                conn.close("Shutdown of ClientEngine", null);
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpointManager.clear();
        this.ownershipMappings.clear();
    }

    public String addOwnershipMapping(String clientUuid, String ownerUuid) {
        return this.ownershipMappings.put(clientUuid, ownerUuid);
    }

    public void removeClient(String clientUuid) {
        this.ownershipMappings.remove(clientUuid);
        Set<ClientEndpoint> endpoints = this.endpointManager.getEndpoints(clientUuid);
        for (ClientEndpoint endpoint : endpoints) {
            this.endpointManager.removeEndpoint(endpoint, true, "Resources are being cleaned up for client " + clientUuid);
        }
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        nodeEngine.onClientDisconnected(clientUuid);
        Collection<ClientAwareService> services = nodeEngine.getServices(ClientAwareService.class);
        for (ClientAwareService service : services) {
            service.clientDisconnected(clientUuid);
        }
    }

    public TransactionManagerService getTransactionManagerService() {
        return this.node.nodeEngine.getTransactionManagerService();
    }

    private ClientDisconnectionOperation createClientDisconnectionOperation(String clientUuid) {
        ClientDisconnectionOperation op = new ClientDisconnectionOperation(clientUuid);
        op.setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME).setService(this).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        return op;
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.ownershipMappings.isEmpty() ? null : new PostJoinClientOperation(this.ownershipMappings);
    }

    @Override
    public Map<ClientType, Integer> getConnectedClientStats() {
        int numberOfCppClients = 0;
        int numberOfDotNetClients = 0;
        int numberOfJavaClients = 0;
        int numberOfNodeJSClients = 0;
        int numberOfPythonClients = 0;
        int numberOfOtherClients = 0;
        InternalOperationService operationService = this.node.nodeEngine.getOperationService();
        HashMap<ClientType, Integer> resultMap = new HashMap<ClientType, Integer>();
        HashMap clientsMap = new HashMap();
        for (Member member : this.node.getClusterService().getMembers()) {
            Address target = member.getAddress();
            GetConnectedClientsOperation clientInfoOperation = new GetConnectedClientsOperation();
            InternalCompletableFuture future = operationService.invokeOnTarget(SERVICE_NAME, clientInfoOperation, target);
            try {
                Map endpoints = (Map)future.get();
                if (endpoints == null) continue;
                for (Map.Entry entry : endpoints.entrySet()) {
                    clientsMap.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                this.logger.warning("Cannot get client information from: " + target.toString(), e);
            }
        }
        block11: for (ClientType clientType : clientsMap.values()) {
            switch (clientType) {
                case JAVA: {
                    ++numberOfJavaClients;
                    continue block11;
                }
                case CSHARP: {
                    ++numberOfDotNetClients;
                    continue block11;
                }
                case CPP: {
                    ++numberOfCppClients;
                    continue block11;
                }
                case NODEJS: {
                    ++numberOfNodeJSClients;
                    continue block11;
                }
                case PYTHON: {
                    ++numberOfPythonClients;
                    continue block11;
                }
            }
            ++numberOfOtherClients;
        }
        resultMap.put(ClientType.CPP, numberOfCppClients);
        resultMap.put(ClientType.CSHARP, numberOfDotNetClients);
        resultMap.put(ClientType.JAVA, numberOfJavaClients);
        resultMap.put(ClientType.NODEJS, numberOfNodeJSClients);
        resultMap.put(ClientType.PYTHON, numberOfPythonClients);
        resultMap.put(ClientType.OTHER, numberOfOtherClients);
        return resultMap;
    }

    private static class PriorityPartitionSpecificRunnable
    implements PartitionSpecificRunnable,
    UrgentSystemOperation {
        private final MessageTask task;

        public PriorityPartitionSpecificRunnable(MessageTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public int getPartitionId() {
            return this.task.getPartitionId();
        }

        public String toString() {
            return "PriorityPartitionSpecificRunnable:{ " + this.task + "}";
        }
    }

    private class DestroyEndpointTask
    implements Runnable {
        private final String deadMemberUuid;

        public DestroyEndpointTask(String deadMemberUuid) {
            this.deadMemberUuid = deadMemberUuid;
        }

        @Override
        public void run() {
            ClientEngineImpl.this.endpointManager.removeEndpoints(this.deadMemberUuid);
            this.removeMappings();
        }

        void removeMappings() {
            Iterator iterator = ClientEngineImpl.this.ownershipMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String clientUuid = (String)entry.getKey();
                String memberUuid = (String)entry.getValue();
                if (!this.deadMemberUuid.equals(memberUuid)) continue;
                iterator.remove();
                ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(clientUuid);
                ClientEngineImpl.this.nodeEngine.getOperationService().run(op);
            }
        }
    }

    private final class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connectionAdded(Connection conn) {
        }

        @Override
        public void connectionRemoved(Connection connection) {
            block6: {
                if (connection.isClient() && ClientEngineImpl.this.nodeEngine.isRunning()) {
                    String ownerUuid;
                    final ClientEndpointImpl endpoint = (ClientEndpointImpl)ClientEngineImpl.this.endpointManager.getEndpoint(connection);
                    if (endpoint == null) {
                        ClientEngineImpl.this.logger.finest("connectionRemoved: No endpoint for connection:" + connection);
                        return;
                    }
                    if (!endpoint.isFirstConnection()) {
                        ClientEngineImpl.this.logger.finest("connectionRemoved: Not the owner conn:" + connection + " for endpoint " + endpoint);
                        return;
                    }
                    String localMemberUuid = ClientEngineImpl.this.node.getLocalMember().getUuid();
                    if (localMemberUuid.equals(ownerUuid = endpoint.getPrincipal().getOwnerUuid())) {
                        try {
                            ClientEngineImpl.this.nodeEngine.getExecutionService().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    ConnectionListenerImpl.this.callDisconnectionOperation(endpoint);
                                }
                            }, 10L, TimeUnit.SECONDS);
                        }
                        catch (RejectedExecutionException e) {
                            if (!ClientEngineImpl.this.logger.isFinestEnabled()) break block6;
                            ClientEngineImpl.this.logger.finest(e);
                        }
                    }
                }
            }
        }

        private void callDisconnectionOperation(ClientEndpointImpl endpoint) {
            Set<Member> memberList = ClientEngineImpl.this.nodeEngine.getClusterService().getMembers();
            InternalOperationService operationService = ClientEngineImpl.this.nodeEngine.getOperationService();
            String memberUuid = ClientEngineImpl.this.getLocalMember().getUuid();
            String clientUuid = endpoint.getUuid();
            String ownerMember = (String)ClientEngineImpl.this.ownershipMappings.get(clientUuid);
            if (!memberUuid.equals(ownerMember)) {
                return;
            }
            ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(clientUuid);
            operationService.run(op);
            for (Member member : memberList) {
                if (member.localMember()) continue;
                op = ClientEngineImpl.this.createClientDisconnectionOperation(clientUuid);
                operationService.send(op, member.getAddress());
            }
        }
    }
}

