/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.cluster.ClusterClock;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.BlockingOperation;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.InvocationMonitor;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.InvocationValue;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationutil.Operations;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;

public abstract class Invocation
implements OperationResponseHandler {
    private static final AtomicReferenceFieldUpdater<Invocation, Boolean> RESPONSE_RECEIVED = AtomicReferenceFieldUpdater.newUpdater(Invocation.class, Boolean.class, "responseReceived");
    private static final AtomicIntegerFieldUpdater<Invocation> BACKUP_ACKS_RECEIVED = AtomicIntegerFieldUpdater.newUpdater(Invocation.class, "backupsAcksReceived");
    private static final long MIN_TIMEOUT = 10000L;
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    private static final int LOG_MAX_INVOCATION_COUNT = 99;
    private static final int LOG_INVOCATION_COUNT_MOD = 10;
    public final Operation op;
    public final long firstInvocationTimeMillis = Clock.currentTimeMillis();
    final Context context;
    volatile Object pendingResponse = InvocationValue.VOID;
    volatile long pendingResponseReceivedMillis = -1L;
    volatile int backupsAcksExpected;
    volatile int backupsAcksReceived;
    volatile Boolean responseReceived = Boolean.FALSE;
    volatile long lastHeartbeatMillis;
    final InvocationFuture future;
    final int tryCount;
    final long tryPauseMillis;
    final long callTimeoutMillis;
    boolean remote;
    Address invTarget;
    MemberImpl targetMember;
    volatile int invokeCount;

    Invocation(Context context, Operation op, int tryCount, long tryPauseMillis, long callTimeoutMillis, boolean deserialize) {
        this.context = context;
        this.op = op;
        this.tryCount = tryCount;
        this.tryPauseMillis = tryPauseMillis;
        this.callTimeoutMillis = this.getCallTimeoutMillis(callTimeoutMillis);
        this.future = new InvocationFuture(this, deserialize);
    }

    abstract ExceptionAction onException(Throwable var1);

    protected abstract Address getTarget();

    private long getCallTimeoutMillis(long callTimeoutMillis) {
        if (callTimeoutMillis > 0L) {
            return callTimeoutMillis;
        }
        long defaultCallTimeoutMillis = this.context.defaultCallTimeoutMillis;
        if (!(this.op instanceof BlockingOperation)) {
            return defaultCallTimeoutMillis;
        }
        long waitTimeoutMillis = this.op.getWaitTimeout();
        if (waitTimeoutMillis > 0L && waitTimeoutMillis < Long.MAX_VALUE) {
            long max = Math.max(waitTimeoutMillis, 10000L);
            return Math.min(max, defaultCallTimeoutMillis);
        }
        return defaultCallTimeoutMillis;
    }

    public final InvocationFuture invoke() {
        this.invoke0(false);
        return this.future;
    }

    public final InvocationFuture invokeAsync() {
        this.invoke0(true);
        return this.future;
    }

    private void invoke0(boolean isAsync) {
        if (this.invokeCount > 0) {
            throw new IllegalStateException("An invocation can not be invoked more than once!");
        }
        if (this.op.getCallId() != 0L) {
            throw new IllegalStateException("An operation[" + this.op + "] can not be used for multiple invocations!");
        }
        try {
            OperationAccessor.setCallTimeout(this.op, this.callTimeoutMillis);
            OperationAccessor.setCallerAddress(this.op, this.context.thisAddress);
            this.op.setNodeEngine(this.context.nodeEngine);
            boolean isAllowed = this.context.operationExecutor.isInvocationAllowed(this.op, isAsync);
            if (!isAllowed && !Operations.isMigrationOperation(this.op)) {
                throw new IllegalThreadStateException(Thread.currentThread() + " cannot make remote call: " + this.op);
            }
            this.doInvoke(isAsync);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
    }

    private void handleInvocationException(Exception e) {
        if (!(e instanceof RetryableException)) {
            throw ExceptionUtil.rethrow(e);
        }
        this.notifyError(e);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only a single thread at any given time can change the volatile field")
    private void doInvoke(boolean isAsync) {
        if (!this.engineActive()) {
            return;
        }
        ++this.invokeCount;
        if (!this.initInvocationTarget()) {
            return;
        }
        OperationAccessor.setInvocationTime(this.op, this.context.clusterClock.getClusterTime());
        if (!this.context.invocationRegistry.register(this)) {
            return;
        }
        if (this.remote) {
            this.doInvokeRemote();
        } else {
            this.doInvokeLocal(isAsync);
        }
    }

    private void doInvokeLocal(boolean isAsync) {
        if (this.op.getCallerUuid() == null) {
            this.op.setCallerUuid(this.context.localMemberUuid);
        }
        this.responseReceived = Boolean.FALSE;
        this.op.setOperationResponseHandler(this);
        if (isAsync) {
            this.context.operationExecutor.execute(this.op);
        } else {
            this.context.operationExecutor.runOrExecute(this.op);
        }
    }

    private void doInvokeRemote() {
        if (!this.context.operationService.send(this.op, this.invTarget)) {
            this.context.invocationRegistry.deregister(this);
            this.notifyError(new RetryableIOException("Packet not send to -> " + this.invTarget));
        }
    }

    private boolean engineActive() {
        boolean allowed;
        NodeState state = this.context.node.getState();
        if (state == NodeState.ACTIVE) {
            return true;
        }
        boolean bl = allowed = state == NodeState.PASSIVE && this.op instanceof AllowedDuringPassiveState;
        if (!allowed) {
            this.notifyError(new HazelcastInstanceNotActiveException("State: " + (Object)((Object)state) + " Operation: " + this.op.getClass()));
            this.remote = false;
        }
        return allowed;
    }

    boolean initInvocationTarget() {
        this.invTarget = this.getTarget();
        if (this.invTarget == null) {
            this.remote = false;
            this.notifyWithExceptionWhenTargetIsNull();
            return false;
        }
        this.targetMember = this.context.clusterService.getMember(this.invTarget);
        if (this.targetMember == null && !Operations.isJoinOperation(this.op) && !Operations.isWanReplicationOperation(this.op)) {
            this.notifyError(new TargetNotMemberException(this.invTarget, this.op.getPartitionId(), this.op.getClass().getName(), this.op.getServiceName()));
            return false;
        }
        this.remote = !this.context.thisAddress.equals(this.invTarget);
        return true;
    }

    private void notifyWithExceptionWhenTargetIsNull() {
        ClusterState clusterState = this.context.clusterService.getClusterState();
        if (clusterState == ClusterState.FROZEN || clusterState == ClusterState.PASSIVE) {
            this.notifyError(new IllegalStateException("Partitions can't be assigned since cluster-state: " + (Object)((Object)clusterState)));
        } else if (this.context.clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) == 0) {
            this.notifyError(new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members"));
        } else {
            this.notifyError(new WrongTargetException(this.context.thisAddress, null, this.op.getPartitionId(), this.op.getReplicaIndex(), this.op.getClass().getName(), this.op.getServiceName()));
        }
    }

    public void sendResponse(Operation op, Object response) {
        if (!RESPONSE_RECEIVED.compareAndSet(this, Boolean.FALSE, Boolean.TRUE)) {
            throw new ResponseAlreadySentException("NormalResponse already responseReceived for callback: " + this + ", current-response: : " + response);
        }
        if (response instanceof CallTimeoutResponse) {
            this.notifyCallTimeout();
        } else if (response instanceof ErrorResponse || response instanceof Throwable) {
            this.notifyError(response);
        } else if (response instanceof NormalResponse) {
            NormalResponse normalResponse = (NormalResponse)response;
            this.notifyNormalResponse(normalResponse.getValue(), normalResponse.getBackupAcks());
        } else {
            this.complete(response);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    void notifyError(Object error) {
        assert (error != null);
        Throwable cause = error instanceof Throwable ? (Throwable)error : ((ErrorResponse)error).getCause();
        switch (this.onException(cause)) {
            case THROW_EXCEPTION: {
                this.notifyNormalResponse(cause, 0);
                break;
            }
            case RETRY_INVOCATION: {
                if (this.invokeCount < this.tryCount) {
                    this.handleRetry(cause);
                    break;
                }
                this.notifyNormalResponse(cause, 0);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled ExceptionAction");
            }
        }
    }

    void notifyNormalResponse(Object value, int expectedBackups) {
        if (expectedBackups > this.backupsAcksReceived) {
            this.pendingResponseReceivedMillis = Clock.currentTimeMillis();
            this.backupsAcksExpected = expectedBackups;
            this.pendingResponse = value;
            if (this.backupsAcksReceived != expectedBackups) {
                return;
            }
        }
        this.complete(value);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only a single thread at any given time can change the volatile field")
    void notifyCallTimeout() {
        if (!(this.op instanceof BlockingOperation)) {
            this.complete(InvocationValue.CALL_TIMEOUT);
            return;
        }
        if (this.context.logger.isFinestEnabled()) {
            this.context.logger.finest("Call timed-out either in operation queue or during wait-notify phase, retrying call: " + this);
        }
        long waitTimeout = this.op.getWaitTimeout();
        this.op.setWaitTimeout(waitTimeout -= this.callTimeoutMillis);
        --this.invokeCount;
        this.handleRetry("invocation timeout");
    }

    void notifyBackupComplete() {
        int newBackupAcksCompleted = BACKUP_ACKS_RECEIVED.incrementAndGet(this);
        Object pendingResponse = this.pendingResponse;
        if (pendingResponse == InvocationValue.VOID) {
            return;
        }
        int backupAcksExpected = this.backupsAcksExpected;
        if (backupAcksExpected < newBackupAcksCompleted) {
            return;
        }
        if (backupAcksExpected != newBackupAcksCompleted) {
            return;
        }
        this.complete(pendingResponse);
    }

    private void complete(Object value) {
        if (this.future.complete(value)) {
            this.context.invocationRegistry.deregister(this);
        }
    }

    private void handleRetry(Object cause) {
        this.context.retryCount.inc();
        if (this.invokeCount % 10 == 0) {
            Level level;
            Level level2 = level = this.invokeCount > 99 ? Level.WARNING : Level.FINEST;
            if (this.context.logger.isLoggable(level)) {
                this.context.logger.log(level, "Retrying invocation: " + this.toString() + ", Reason: " + cause);
            }
        }
        if (this.future.interrupted) {
            this.complete(InvocationValue.INTERRUPTED);
        } else {
            this.context.invocationRegistry.deregister(this);
            try {
                if (this.invokeCount < 5) {
                    this.context.asyncExecutor.execute(new InvocationRetryTask());
                } else {
                    this.context.executionService.schedule("hz:async", new InvocationRetryTask(), this.tryPauseMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (RejectedExecutionException e) {
                this.completeWhenRetryRejected(e);
            }
        }
    }

    private void completeWhenRetryRejected(RejectedExecutionException e) {
        if (this.context.logger.isFinestEnabled()) {
            this.context.logger.finest(e);
        }
        this.complete(new HazelcastInstanceNotActiveException(e.getMessage()));
    }

    boolean detectAndHandleTimeout(long heartbeatTimeoutMillis) {
        if (!this.remote && !(this.op instanceof BackupAwareOperation)) {
            return false;
        }
        HeartbeatTimeout heartbeatTimeout = this.detectTimeout(heartbeatTimeoutMillis);
        if (heartbeatTimeout == HeartbeatTimeout.TIMEOUT) {
            this.complete(InvocationValue.HEARTBEAT_TIMEOUT);
            return true;
        }
        return false;
    }

    HeartbeatTimeout detectTimeout(long heartbeatTimeoutMillis) {
        long heartbeatExpirationTimeMillis;
        if (this.pendingResponse != InvocationValue.VOID) {
            return HeartbeatTimeout.NO_TIMEOUT__RESPONSE_AVAILABLE;
        }
        long callTimeoutMillis = this.op.getCallTimeout();
        if (callTimeoutMillis <= 0L || callTimeoutMillis == Long.MAX_VALUE) {
            return HeartbeatTimeout.NO_TIMEOUT__CALL_TIMEOUT_DISABLED;
        }
        long deadlineMillis = this.op.getInvocationTime() + callTimeoutMillis;
        if (deadlineMillis > this.context.clusterClock.getClusterTime()) {
            return HeartbeatTimeout.NO_TIMEOUT__CALL_TIMEOUT_NOT_EXPIRED;
        }
        long lastHeartbeatMillis = this.lastHeartbeatMillis;
        long l = heartbeatExpirationTimeMillis = lastHeartbeatMillis == 0L ? this.op.getInvocationTime() + callTimeoutMillis + heartbeatTimeoutMillis : lastHeartbeatMillis + heartbeatTimeoutMillis;
        if (heartbeatExpirationTimeMillis > Clock.currentTimeMillis()) {
            return HeartbeatTimeout.NO_TIMEOUT__HEARTBEAT_TIMEOUT_NOT_EXPIRED;
        }
        return HeartbeatTimeout.TIMEOUT;
    }

    boolean detectAndHandleBackupTimeout(long timeoutMillis) {
        boolean targetDead;
        boolean responseReceived;
        boolean backupsCompleted = this.backupsAcksExpected == this.backupsAcksReceived;
        long responseReceivedMillis = this.pendingResponseReceivedMillis;
        long expirationTime = responseReceivedMillis + timeoutMillis;
        boolean timeout = expirationTime > 0L && expirationTime < Clock.currentTimeMillis();
        boolean bl = responseReceived = this.pendingResponse != InvocationValue.VOID;
        if (backupsCompleted || !responseReceived || !timeout) {
            return false;
        }
        boolean bl2 = targetDead = this.context.clusterService.getMember(this.invTarget) == null;
        if (targetDead) {
            this.resetAndReInvoke();
            return false;
        }
        this.complete(this.pendingResponse);
        return true;
    }

    private void resetAndReInvoke() {
        this.context.invocationRegistry.deregister(this);
        this.invokeCount = 0;
        this.pendingResponse = InvocationValue.VOID;
        this.pendingResponseReceivedMillis = -1L;
        this.backupsAcksExpected = 0;
        this.backupsAcksReceived = 0;
        this.lastHeartbeatMillis = 0L;
        this.doInvoke(false);
    }

    public String toString() {
        String connectionStr = null;
        Address invTarget = this.invTarget;
        if (invTarget != null) {
            ConnectionManager connectionManager = this.context.connectionManager;
            Connection connection = connectionManager.getConnection(invTarget);
            connectionStr = connection == null ? null : connection.toString();
        }
        return "Invocation{op=" + this.op + ", tryCount=" + this.tryCount + ", tryPauseMillis=" + this.tryPauseMillis + ", invokeCount=" + this.invokeCount + ", callTimeoutMillis=" + this.callTimeoutMillis + ", firstInvocationTimeMs=" + this.firstInvocationTimeMillis + ", firstInvocationTime='" + StringUtil.timeToString(this.firstInvocationTimeMillis) + "'" + ", lastHeartbeatMillis=" + this.lastHeartbeatMillis + ", lastHeartbeatTime='" + StringUtil.timeToString(this.lastHeartbeatMillis) + "'" + ", target=" + invTarget + ", pendingResponse={" + this.pendingResponse + "}" + ", backupsAcksExpected=" + this.backupsAcksExpected + ", backupsAcksReceived=" + this.backupsAcksReceived + ", connection=" + connectionStr + '}';
    }

    static class Context {
        final ManagedExecutorService asyncExecutor;
        final ClusterClock clusterClock;
        final ClusterService clusterService;
        final ConnectionManager connectionManager;
        final InternalExecutionService executionService;
        final long defaultCallTimeoutMillis;
        final InvocationRegistry invocationRegistry;
        final InvocationMonitor invocationMonitor;
        final String localMemberUuid;
        final ILogger logger;
        final Node node;
        final NodeEngine nodeEngine;
        final InternalPartitionService partitionService;
        final OperationServiceImpl operationService;
        final OperationExecutor operationExecutor;
        final MwCounter retryCount;
        final InternalSerializationService serializationService;
        final Address thisAddress;

        Context(ManagedExecutorService asyncExecutor, ClusterClock clusterClock, ClusterService clusterService, ConnectionManager connectionManager, InternalExecutionService executionService, long defaultCallTimeoutMillis, InvocationRegistry invocationRegistry, InvocationMonitor invocationMonitor, String localMemberUuid, ILogger logger, Node node, NodeEngine nodeEngine, InternalPartitionService partitionService, OperationServiceImpl operationService, OperationExecutor operationExecutor, MwCounter retryCount, InternalSerializationService serializationService, Address thisAddress) {
            this.asyncExecutor = asyncExecutor;
            this.clusterClock = clusterClock;
            this.clusterService = clusterService;
            this.connectionManager = connectionManager;
            this.executionService = executionService;
            this.defaultCallTimeoutMillis = defaultCallTimeoutMillis;
            this.invocationRegistry = invocationRegistry;
            this.invocationMonitor = invocationMonitor;
            this.localMemberUuid = localMemberUuid;
            this.logger = logger;
            this.node = node;
            this.nodeEngine = nodeEngine;
            this.partitionService = partitionService;
            this.operationService = operationService;
            this.operationExecutor = operationExecutor;
            this.retryCount = retryCount;
            this.serializationService = serializationService;
            this.thisAddress = thisAddress;
        }
    }

    static enum HeartbeatTimeout {
        NO_TIMEOUT__CALL_TIMEOUT_DISABLED,
        NO_TIMEOUT__RESPONSE_AVAILABLE,
        NO_TIMEOUT__HEARTBEAT_TIMEOUT_NOT_EXPIRED,
        NO_TIMEOUT__CALL_TIMEOUT_NOT_EXPIRED,
        TIMEOUT;

    }

    private class InvocationRetryTask
    implements Runnable {
        private InvocationRetryTask() {
        }

        @Override
        public void run() {
            if (!(Invocation.this.context.node.joined() || Operations.isJoinOperation(Invocation.this.op) || Invocation.this.op instanceof AllowedDuringPassiveState)) {
                if (!Invocation.this.engineActive()) {
                    return;
                }
                if (Invocation.this.context.logger.isFinestEnabled()) {
                    Invocation.this.context.logger.finest("Node is not joined. Re-scheduling " + this + " to be executed in " + Invocation.this.tryPauseMillis + " ms.");
                }
                try {
                    Invocation.this.context.executionService.schedule("hz:async", this, Invocation.this.tryPauseMillis, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    Invocation.this.completeWhenRetryRejected(e);
                }
                return;
            }
            Invocation.this.doInvoke(false);
        }
    }
}

