/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.internal.cluster.impl.BindMessage;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.IOThreadingModel;
import com.hazelcast.nio.tcp.InitConnectionTask;
import com.hazelcast.nio.tcp.SocketAcceptorThread;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionMonitor;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadingModel;
import com.hazelcast.nio.tcp.nonblocking.iobalancer.IOBalancer;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.StripedRunnable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TcpIpConnectionManager
implements ConnectionManager,
PacketHandler {
    private static final int RETRY_NUMBER = 5;
    private static final int DELAY_FACTOR = 100;
    final LoggingService loggingService;
    @Probe(name="connectionListenerCount")
    final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final IOService ioService;
    private final ConstructorFunction<Address, TcpIpConnectionMonitor> monitorConstructor = new ConstructorFunction<Address, TcpIpConnectionMonitor>(){

        @Override
        public TcpIpConnectionMonitor createNew(Address endpoint) {
            return new TcpIpConnectionMonitor(TcpIpConnectionManager.this, endpoint);
        }
    };
    private final ILogger logger;
    @Probe(name="count", level=ProbeLevel.MANDATORY)
    private final ConcurrentHashMap<Address, Connection> connectionsMap = new ConcurrentHashMap(100);
    @Probe(name="monitorCount")
    private final ConcurrentHashMap<Address, TcpIpConnectionMonitor> monitors = new ConcurrentHashMap(100);
    @Probe(name="inProgressCount")
    private final Set<Address> connectionsInProgress = Collections.newSetFromMap(new ConcurrentHashMap());
    @Probe(name="acceptedSocketCount", level=ProbeLevel.MANDATORY)
    private final Set<SocketChannelWrapper> acceptedSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    @Probe(name="activeCount", level=ProbeLevel.MANDATORY)
    private final Set<TcpIpConnection> activeConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    @Probe(name="textCount", level=ProbeLevel.MANDATORY)
    private final AtomicInteger allTextConnections = new AtomicInteger();
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private final IOThreadingModel ioThreadingModel;
    private final MetricsRegistry metricsRegistry;
    private volatile boolean live;
    private final ServerSocketChannel serverSocketChannel;
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final int outboundPortCount;
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private volatile SocketAcceptorThread acceptorThread;
    @Probe
    private final MwCounter openedCount = MwCounter.newMwCounter();
    @Probe
    private final MwCounter closedCount = MwCounter.newMwCounter();
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(4);

    public TcpIpConnectionManager(IOService ioService, ServerSocketChannel serverSocketChannel, MetricsRegistry metricsRegistry, HazelcastThreadGroup threadGroup, LoggingService loggingService) {
        this(ioService, serverSocketChannel, loggingService, metricsRegistry, new NonBlockingIOThreadingModel(ioService, loggingService, metricsRegistry, threadGroup));
    }

    public TcpIpConnectionManager(IOService ioService, ServerSocketChannel serverSocketChannel, LoggingService loggingService, MetricsRegistry metricsRegistry, IOThreadingModel ioThreadingModel) {
        this.ioService = ioService;
        this.ioThreadingModel = ioThreadingModel;
        this.serverSocketChannel = serverSocketChannel;
        this.loggingService = loggingService;
        this.logger = loggingService.getLogger(TcpIpConnectionManager.class);
        Collection<Integer> ports = ioService.getOutboundPorts();
        this.outboundPortCount = ports.size();
        this.outboundPorts.addAll(ports);
        this.socketChannelWrapperFactory = ioService.getSocketChannelWrapperFactory();
        this.metricsRegistry = metricsRegistry;
        metricsRegistry.scanAndRegister(this, "tcp.connection");
    }

    public IOService getIoService() {
        return this.ioService;
    }

    public IOThreadingModel getIoThreadingModel() {
        return this.ioThreadingModel;
    }

    public void interceptSocket(Socket socket, boolean onAccept) throws IOException {
        if (!this.isSocketInterceptorEnabled()) {
            return;
        }
        MemberSocketInterceptor memberSocketInterceptor = this.ioService.getMemberSocketInterceptor();
        if (memberSocketInterceptor == null) {
            return;
        }
        if (onAccept) {
            memberSocketInterceptor.onAccept(socket);
        } else {
            memberSocketInterceptor.onConnect(socket);
        }
    }

    public boolean isSocketInterceptorEnabled() {
        SocketInterceptorConfig socketInterceptorConfig = this.ioService.getSocketInterceptorConfig();
        return socketInterceptorConfig != null && socketInterceptorConfig.isEnabled();
    }

    public Set<TcpIpConnection> getActiveConnections() {
        return this.activeConnections;
    }

    public IOBalancer getIoBalancer() {
        if (this.ioThreadingModel instanceof NonBlockingIOThreadingModel) {
            return ((NonBlockingIOThreadingModel)this.ioThreadingModel).getIOBalancer();
        }
        return null;
    }

    @Override
    public int getActiveConnectionCount() {
        return this.activeConnections.size();
    }

    @Override
    public int getAllTextConnections() {
        return this.allTextConnections.get();
    }

    @Override
    public int getConnectionCount() {
        return this.connectionsMap.size();
    }

    public boolean isSSLEnabled() {
        return this.socketChannelWrapperFactory.isSSlEnabled();
    }

    public void incrementTextConnections() {
        this.allTextConnections.incrementAndGet();
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        this.connectionListeners.add(listener);
    }

    @Override
    public void handle(Packet packet) throws Exception {
        assert (packet.isFlagSet(32));
        BindMessage bind = (BindMessage)this.ioService.getSerializationService().toObject(packet);
        this.bind((TcpIpConnection)packet.getConn(), bind.getLocalAddress(), bind.getTargetAddress(), bind.shouldReply());
    }

    private synchronized boolean bind(TcpIpConnection connection, Address remoteEndPoint, Address localEndpoint, boolean reply) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Binding " + connection + " to " + remoteEndPoint + ", reply is " + reply);
        }
        Address thisAddress = this.ioService.getThisAddress();
        if (this.ioService.isSocketBindAny() && !connection.isClient() && !thisAddress.equals(localEndpoint)) {
            String msg = "Wrong bind request from " + remoteEndPoint + "! This node is not requested endpoint: " + localEndpoint;
            this.logger.warning(msg);
            connection.close(msg, null);
            return false;
        }
        connection.setEndPoint(remoteEndPoint);
        this.ioService.onSuccessfulConnection(remoteEndPoint);
        if (reply) {
            this.sendBindRequest(connection, remoteEndPoint, false);
        }
        if (this.checkAlreadyConnected(connection, remoteEndPoint)) {
            return false;
        }
        return this.registerConnection(remoteEndPoint, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean registerConnection(final Address remoteEndPoint, final Connection connection) {
        try {
            if (remoteEndPoint.equals(this.ioService.getThisAddress())) {
                boolean bl = false;
                return bl;
            }
            if (!connection.isAlive()) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(connection + " to " + remoteEndPoint + " is not registered since connection is not active.");
                }
                boolean bl = false;
                return bl;
            }
            if (connection instanceof TcpIpConnection) {
                TcpIpConnection tcpConnection = (TcpIpConnection)connection;
                Address currentEndPoint = tcpConnection.getEndPoint();
                if (currentEndPoint != null && !currentEndPoint.equals(remoteEndPoint)) {
                    throw new IllegalArgumentException(connection + " has already a different endpoint than: " + remoteEndPoint);
                }
                tcpConnection.setEndPoint(remoteEndPoint);
                if (!connection.isClient()) {
                    TcpIpConnectionMonitor connectionMonitor = this.getConnectionMonitor(remoteEndPoint, true);
                    tcpConnection.setMonitor(connectionMonitor);
                }
            }
            this.connectionsMap.put(remoteEndPoint, connection);
            this.ioService.getEventService().executeEventCallback(new StripedRunnable(){

                @Override
                public void run() {
                    for (ConnectionListener listener : TcpIpConnectionManager.this.connectionListeners) {
                        listener.connectionAdded(connection);
                    }
                }

                @Override
                public int getKey() {
                    return remoteEndPoint.hashCode();
                }
            });
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionsInProgress.remove(remoteEndPoint);
        }
    }

    private boolean checkAlreadyConnected(TcpIpConnection connection, Address remoteEndPoint) {
        Connection existingConnection = this.connectionsMap.get(remoteEndPoint);
        if (existingConnection != null && existingConnection.isAlive()) {
            if (existingConnection != connection) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(existingConnection + " is already bound to " + remoteEndPoint + ", new one is " + connection);
                }
                this.activeConnections.add(connection);
            }
            return true;
        }
        return false;
    }

    void sendBindRequest(TcpIpConnection connection, Address remoteEndPoint, boolean replyBack) {
        connection.setEndPoint(remoteEndPoint);
        this.ioService.onSuccessfulConnection(remoteEndPoint);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending bind packet to " + remoteEndPoint);
        }
        BindMessage bind = new BindMessage(this.ioService.getThisAddress(), remoteEndPoint, replyBack);
        byte[] bytes = this.ioService.getSerializationService().toBytes(bind);
        Packet packet = new Packet(bytes);
        packet.setFlag(32);
        connection.write(packet);
    }

    SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
        SocketChannelWrapper wrapper = this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, client);
        this.acceptedSockets.add(wrapper);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TcpIpConnection newConnection(SocketChannelWrapper channel, Address endpoint) {
        try {
            if (!this.live) {
                throw new IllegalStateException("connection manager is not live!");
            }
            TcpIpConnection connection = new TcpIpConnection(this, this.connectionIdGen.incrementAndGet(), channel, this.ioThreadingModel);
            connection.setEndPoint(endpoint);
            this.activeConnections.add(connection);
            connection.start();
            this.ioThreadingModel.onConnectionAdded(connection);
            this.logger.info("Established socket connection between " + channel.socket().getLocalSocketAddress() + " and " + channel.socket().getRemoteSocketAddress());
            this.openedCount.inc();
            TcpIpConnection tcpIpConnection = connection;
            return tcpIpConnection;
        }
        finally {
            this.acceptedSockets.remove(channel);
        }
    }

    void failedConnection(Address address, Throwable t, boolean silent) {
        this.connectionsInProgress.remove(address);
        this.ioService.onFailedConnection(address);
        if (!silent) {
            this.getConnectionMonitor(address, false).onError(t);
        }
    }

    @Override
    public Connection getConnection(Address address) {
        return this.connectionsMap.get(address);
    }

    @Override
    public Connection getOrConnect(Address address) {
        return this.getOrConnect(address, false);
    }

    @Override
    public Connection getOrConnect(Address address, boolean silent) {
        Connection connection = this.connectionsMap.get(address);
        if (connection == null && this.live && this.connectionsInProgress.add(address)) {
            this.ioService.shouldConnectTo(address);
            this.ioService.executeAsync(new InitConnectionTask(this, address, silent));
        }
        return connection;
    }

    private TcpIpConnectionMonitor getConnectionMonitor(Address endpoint, boolean reset) {
        TcpIpConnectionMonitor monitor = ConcurrencyUtil.getOrPutIfAbsent(this.monitors, endpoint, this.monitorConstructor);
        if (reset) {
            monitor.reset();
        }
        return monitor;
    }

    void onClose(Connection connection) {
        Address endPoint;
        this.closedCount.inc();
        if (this.activeConnections.remove(connection) && connection instanceof TcpIpConnection) {
            this.ioThreadingModel.onConnectionRemoved((TcpIpConnection)connection);
        }
        if ((endPoint = connection.getEndPoint()) != null) {
            this.connectionsInProgress.remove(endPoint);
            this.connectionsMap.remove(endPoint, connection);
            this.fireConnectionRemovedEvent(connection, endPoint);
        }
    }

    private void fireConnectionRemovedEvent(final Connection connection, final Address endPoint) {
        if (this.live) {
            this.ioService.getEventService().executeEventCallback(new StripedRunnable(){

                @Override
                public void run() {
                    for (ConnectionListener listener : TcpIpConnectionManager.this.connectionListeners) {
                        listener.connectionRemoved(connection);
                    }
                }

                @Override
                public int getKey() {
                    return endPoint.hashCode();
                }
            });
        }
    }

    protected void initSocket(Socket socket) throws Exception {
        if (this.ioService.getSocketLingerSeconds() > 0) {
            socket.setSoLinger(true, this.ioService.getSocketLingerSeconds());
        }
        socket.setKeepAlive(this.ioService.getSocketKeepAlive());
        socket.setTcpNoDelay(this.ioService.getSocketNoDelay());
        socket.setReceiveBufferSize(this.ioService.getSocketReceiveBufferSize() * 1024);
        socket.setSendBufferSize(this.ioService.getSocketSendBufferSize() * 1024);
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        if (!this.serverSocketChannel.isOpen()) {
            throw new IllegalStateException("ConnectionManager is already shutdown. Cannot start!");
        }
        this.live = true;
        this.logger.finest("Starting ConnectionManager and IO selectors.");
        this.ioThreadingModel.start();
        this.startAcceptorThread();
    }

    private void startAcceptorThread() {
        if (this.acceptorThread != null) {
            this.logger.warning("SocketAcceptor thread is already live! Shutting down old acceptor...");
            this.shutdownAcceptorThread();
        }
        this.acceptorThread = new SocketAcceptorThread(this.ioService.getThreadGroup(), this.ioService.getThreadPrefix() + "Acceptor", this.serverSocketChannel, this);
        this.acceptorThread.start();
        this.metricsRegistry.scanAndRegister(this.acceptorThread, "tcp." + this.acceptorThread.getName());
    }

    @Override
    public synchronized void stop() {
        if (!this.live) {
            return;
        }
        this.live = false;
        this.logger.finest("Stopping ConnectionManager");
        this.shutdownAcceptorThread();
        for (SocketChannelWrapper socketChannelWrapper : this.acceptedSockets) {
            IOUtil.closeResource(socketChannelWrapper);
        }
        for (Connection connection : this.connectionsMap.values()) {
            this.destroySilently(connection, "TcpIpConnectionManager is stopping");
        }
        for (TcpIpConnection tcpIpConnection : this.activeConnections) {
            this.destroySilently(tcpIpConnection, "TcpIpConnectionManager is stopping");
        }
        this.ioThreadingModel.shutdown();
        this.acceptedSockets.clear();
        this.connectionsInProgress.clear();
        this.connectionsMap.clear();
        this.monitors.clear();
        this.activeConnections.clear();
    }

    private void destroySilently(Connection conn, String reason) {
        if (conn == null) {
            return;
        }
        try {
            conn.close(reason, null);
        }
        catch (Throwable ignore) {
            this.logger.finest(ignore);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shutdownAcceptorThread();
        this.closeServerSocket();
        this.stop();
        this.connectionListeners.clear();
    }

    private void shutdownAcceptorThread() {
        if (this.acceptorThread != null) {
            this.acceptorThread.shutdown();
            this.metricsRegistry.deregister(this.acceptorThread);
            this.acceptorThread = null;
        }
    }

    private void closeServerSocket() {
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Closing server socket channel: " + this.serverSocketChannel);
            }
            this.serverSocketChannel.close();
        }
        catch (IOException ignore) {
            this.logger.finest(ignore);
        }
    }

    @Override
    @Probe(name="clientCount", level=ProbeLevel.MANDATORY)
    public int getCurrentClientConnections() {
        int count = 0;
        for (TcpIpConnection conn : this.activeConnections) {
            if (!conn.isAlive() || !conn.isClient()) continue;
            ++count;
        }
        return count;
    }

    public boolean isLive() {
        return this.live;
    }

    boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    int getOutboundPortCount() {
        return this.outboundPortCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int acquireOutboundPort() {
        if (this.useAnyOutboundPort()) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    @Override
    public boolean transmit(Packet packet, Connection connection) {
        Preconditions.checkNotNull(packet, "Packet can't be null");
        if (connection == null) {
            return false;
        }
        return connection.write(packet);
    }

    @Override
    public boolean transmit(Packet packet, Address target) {
        Preconditions.checkNotNull(packet, "Packet can't be null");
        Preconditions.checkNotNull(target, "target can't be null");
        return this.send(packet, target, null);
    }

    private boolean send(Packet packet, Address target, SendTask sendTask) {
        int retries;
        Connection connection = this.getConnection(target);
        if (connection != null) {
            return connection.write(packet);
        }
        if (sendTask == null) {
            sendTask = new SendTask(packet, target);
        }
        if ((retries = sendTask.retries) < 5 && this.ioService.isActive()) {
            this.getOrConnect(target, true);
            this.scheduler.schedule(sendTask, (long)((retries + 1) * 100), TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connections {");
        for (Connection conn : this.connectionsMap.values()) {
            sb.append("\n");
            sb.append(conn);
        }
        sb.append("\nlive=");
        sb.append(this.live);
        sb.append("\n}");
        return sb.toString();
    }

    private final class SendTask
    implements Runnable {
        private final Packet packet;
        private final Address target;
        private volatile int retries;

        private SendTask(Packet packet, Address target) {
            this.packet = packet;
            this.target = target;
        }

        @Override
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="single-writer, many-reader")
        public void run() {
            ++this.retries;
            if (TcpIpConnectionManager.this.logger.isFinestEnabled()) {
                TcpIpConnectionManager.this.logger.finest("Retrying[" + this.retries + "] packet send operation to: " + this.target);
            }
            TcpIpConnectionManager.this.send(this.packet, this.target, this);
        }
    }
}

