/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntries;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.RecordReplicationInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation
implements MutatingOperation {
    protected final MapReplicationStateHolder mapReplicationStateHolder = new MapReplicationStateHolder();
    protected final WriteBehindStateHolder writeBehindStateHolder = new WriteBehindStateHolder();

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.mapReplicationStateHolder.prepare(container, replicaIndex);
        this.writeBehindStateHolder.prepare(container, replicaIndex);
    }

    @Override
    public void run() {
        this.mapReplicationStateHolder.applyState();
        this.writeBehindStateHolder.applyState();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapReplicationStateHolder.readData(in);
        this.writeBehindStateHolder.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.mapReplicationStateHolder.writeData(out);
        this.writeBehindStateHolder.writeData(out);
    }

    private RecordReplicationInfo createRecordReplicationInfo(Data key, Record record, MapServiceContext mapServiceContext) {
        RecordInfo info = Records.buildRecordInfo(record);
        return new RecordReplicationInfo(key, mapServiceContext.toData(record.getValue()), info);
    }

    private RecordStore getRecordStore(String mapName) {
        boolean skipLoadingOnRecordStoreCreate = true;
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getRecordStore(this.getPartitionId(), mapName, true);
    }

    private class WriteBehindStateHolder
    implements DataSerializable {
        private Map<String, List<DelayedEntry>> delayedEntries;
        private Map<String, Queue<WriteBehindStore.Sequence>> flushSequences;

        private WriteBehindStateHolder() {
        }

        private void prepare(PartitionContainer container, int replicaIndex) {
            int size = container.getMaps().size();
            this.flushSequences = new HashMap<String, Queue<WriteBehindStore.Sequence>>(size);
            this.delayedEntries = new HashMap<String, List<DelayedEntry>>(size);
            for (Map.Entry entry : container.getMaps().entrySet()) {
                WriteBehindStore mapDataStore;
                WriteBehindQueue<DelayedEntry> writeBehindQueue;
                List<DelayedEntry> entries;
                RecordStore recordStore = (RecordStore)entry.getValue();
                MapContainer mapContainer = recordStore.getMapContainer();
                MapConfig mapConfig = mapContainer.getMapConfig();
                if (mapConfig.getTotalBackupCount() < replicaIndex || !mapContainer.getMapStoreContext().isWriteBehindMapStoreEnabled() || (entries = (writeBehindQueue = (mapDataStore = (WriteBehindStore)recordStore.getMapDataStore()).getWriteBehindQueue()).asList()) == null || entries.isEmpty()) continue;
                String mapName = (String)entry.getKey();
                this.delayedEntries.put(mapName, entries);
                this.flushSequences.put(mapName, new ArrayDeque<WriteBehindStore.Sequence>(mapDataStore.getFlushSequences()));
            }
        }

        private void applyState() {
            for (Map.Entry<String, List<DelayedEntry>> entry : this.delayedEntries.entrySet()) {
                String mapName = entry.getKey();
                RecordStore recordStore = MapReplicationOperation.this.getRecordStore(mapName);
                WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
                mapDataStore.reset();
                mapDataStore.setFlushSequences(this.flushSequences.get(mapName));
                Collection replicatedEntries = entry.getValue();
                for (DelayedEntry delayedEntry : replicatedEntries) {
                    mapDataStore.add(delayedEntry);
                    mapDataStore.setSequence(delayedEntry.getSequence());
                }
            }
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            MapService mapService = (MapService)MapReplicationOperation.this.getService();
            MapServiceContext mapServiceContext = mapService.getMapServiceContext();
            out.writeInt(this.delayedEntries.size());
            for (Map.Entry<String, List<DelayedEntry>> entry : this.delayedEntries.entrySet()) {
                out.writeUTF(entry.getKey());
                List<DelayedEntry> delayedEntryList = entry.getValue();
                out.writeInt(delayedEntryList.size());
                for (DelayedEntry e : delayedEntryList) {
                    Data key = mapServiceContext.toData(e.getKey());
                    Data value = mapServiceContext.toData(e.getValue());
                    out.writeData(key);
                    out.writeData(value);
                    out.writeLong(e.getStoreTime());
                    out.writeInt(e.getPartitionId());
                    out.writeLong(e.getSequence());
                }
            }
            out.writeInt(this.flushSequences.size());
            for (Map.Entry<String, Collection<Object>> entry : this.flushSequences.entrySet()) {
                out.writeUTF(entry.getKey());
                Queue queue = (Queue)entry.getValue();
                out.writeInt(queue.size());
                for (WriteBehindStore.Sequence sequence : queue) {
                    out.writeLong(sequence.getSequence());
                    out.writeBoolean(sequence.isFullFlush());
                }
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            this.delayedEntries = new HashMap<String, List<DelayedEntry>>(size);
            for (int i = 0; i < size; ++i) {
                String mapName = in.readUTF();
                int listSize = in.readInt();
                ArrayList<DelayedEntry<Data, Data>> delayedEntriesList = new ArrayList<DelayedEntry<Data, Data>>(listSize);
                for (int j = 0; j < listSize; ++j) {
                    Data key = in.readData();
                    Data value = in.readData();
                    long storeTime = in.readLong();
                    int partitionId = in.readInt();
                    long sequence = in.readLong();
                    DelayedEntry<Data, Data> entry = DelayedEntries.createDefault(key, value, storeTime, partitionId);
                    entry.setSequence(sequence);
                    delayedEntriesList.add(entry);
                }
                this.delayedEntries.put(mapName, delayedEntriesList);
            }
            int expectedSize = in.readInt();
            this.flushSequences = new HashMap<String, Queue<WriteBehindStore.Sequence>>(expectedSize);
            for (int i = 0; i < expectedSize; ++i) {
                String mapName = in.readUTF();
                int setSize = in.readInt();
                ArrayDeque<WriteBehindStore.Sequence> queue = new ArrayDeque<WriteBehindStore.Sequence>(setSize);
                for (int j = 0; j < setSize; ++j) {
                    queue.add(new WriteBehindStore.Sequence(in.readLong(), in.readBoolean()));
                }
                this.flushSequences.put(mapName, queue);
            }
        }
    }

    protected class MapReplicationStateHolder
    implements DataSerializable {
        protected Map<String, Set<RecordReplicationInfo>> data;
        protected Map<String, Boolean> loaded;

        protected MapReplicationStateHolder() {
        }

        private void prepare(PartitionContainer container, int replicaIndex) {
            this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
            this.loaded = new HashMap<String, Boolean>(container.getMaps().size());
            for (Map.Entry entry : container.getMaps().entrySet()) {
                RecordStore recordStore = (RecordStore)entry.getValue();
                MapContainer mapContainer = recordStore.getMapContainer();
                MapConfig mapConfig = mapContainer.getMapConfig();
                if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
                MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
                String mapName = (String)entry.getKey();
                this.loaded.put(mapName, recordStore.isLoaded());
                HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>(recordStore.size());
                Iterator<Record> iterator = recordStore.iterator();
                while (iterator.hasNext()) {
                    Record record = iterator.next();
                    Data key = record.getKey();
                    RecordReplicationInfo recordReplicationInfo = MapReplicationOperation.this.createRecordReplicationInfo(key, record, mapServiceContext);
                    recordSet.add(recordReplicationInfo);
                }
                this.data.put(mapName, recordSet);
            }
        }

        private void applyState() {
            if (this.data != null) {
                for (Map.Entry<String, Set<RecordReplicationInfo>> dataEntry : this.data.entrySet()) {
                    Set<RecordReplicationInfo> recordReplicationInfos = dataEntry.getValue();
                    String mapName = dataEntry.getKey();
                    RecordStore recordStore = MapReplicationOperation.this.getRecordStore(mapName);
                    recordStore.reset();
                    recordStore.setPreMigrationLoadedStatus(this.loaded.get(mapName));
                    for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                        Data key = recordReplicationInfo.getKey();
                        Data value = recordReplicationInfo.getValue();
                        Record newRecord = recordStore.createRecord(value, -1L, Clock.currentTimeMillis());
                        Records.applyRecordInfo(newRecord, recordReplicationInfo);
                        recordStore.putRecord(key, newRecord);
                    }
                }
            }
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.data.size());
            for (Map.Entry<String, Set<RecordReplicationInfo>> entry : this.data.entrySet()) {
                out.writeUTF(entry.getKey());
                Set<RecordReplicationInfo> recordReplicationInfos = entry.getValue();
                out.writeInt(recordReplicationInfos.size());
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    out.writeObject(recordReplicationInfo);
                }
            }
            out.writeInt(this.loaded.size());
            for (Map.Entry<String, Object> entry : this.loaded.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeBoolean((Boolean)entry.getValue());
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
            for (int i = 0; i < size; ++i) {
                String name = in.readUTF();
                int mapSize = in.readInt();
                HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
                for (int j = 0; j < mapSize; ++j) {
                    RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                    recordReplicationInfos.add(recordReplicationInfo);
                }
                this.data.put(name, recordReplicationInfos);
            }
            int loadedSize = in.readInt();
            this.loaded = new HashMap<String, Boolean>(loadedSize);
            for (int i = 0; i < loadedSize; ++i) {
                this.loaded.put(in.readUTF(), in.readBoolean());
            }
        }
    }
}

