/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;

public abstract class BasePutOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Data dataOldValue;
    protected transient EntryEventType eventType;
    protected transient boolean putTransient;

    public BasePutOperation(String name, Data dataKey, Data value) {
        super(name, dataKey, value, -1L);
    }

    public BasePutOperation(String name, Data dataKey, Data value, long ttl) {
        super(name, dataKey, value, ttl);
    }

    public BasePutOperation() {
    }

    @Override
    public void afterRun() {
        this.mapServiceContext.interceptAfterPut(this.name, this.dataValue);
        Data value = this.isPostProcessing(this.recordStore) ? this.recordStore.getRecord(this.dataKey).getValue() : this.dataValue;
        this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.getEventType(), this.dataKey, this.dataOldValue, value);
        this.invalidateNearCache(this.dataKey);
        this.publishWANReplicationEvent(this.mapEventPublisher, value);
        this.evict(this.dataKey);
    }

    private void publishWANReplicationEvent(MapEventPublisher mapEventPublisher, Object value) {
        if (!this.mapContainer.isWanReplicationEnabled()) {
            return;
        }
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record == null) {
            return;
        }
        Data valueConvertedData = this.mapServiceContext.toData(value);
        EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(this.dataKey, valueConvertedData, record);
        mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
    }

    private EntryEventType getEventType() {
        if (this.eventType == null) {
            this.eventType = this.dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        }
        return this.eventType;
    }

    @Override
    public boolean shouldBackup() {
        Object record = this.recordStore.getRecord(this.dataKey);
        return record != null;
    }

    @Override
    public Operation getBackupOperation() {
        Object record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        if (this.isPostProcessing(this.recordStore)) {
            this.dataValue = this.mapServiceContext.toData(record.getValue());
        }
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo, this.putTransient);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }
}

