/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class AbstractMultipleEntryOperation
extends MapOperation
implements MutatingOperation {
    protected MapEntries responses;
    protected EntryProcessor entryProcessor;
    protected EntryBackupProcessor backupProcessor;
    protected List<WanEventWrapper> wanEventList = new ArrayList<WanEventWrapper>();

    protected AbstractMultipleEntryOperation() {
    }

    protected AbstractMultipleEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    protected AbstractMultipleEntryOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name);
        this.backupProcessor = backupProcessor;
    }

    protected Map.Entry createMapEntry(Data key, Object value) {
        InternalSerializationService serializationService = (InternalSerializationService)this.getNodeEngine().getSerializationService();
        return new LazyMapEntry(key, value, serializationService, this.mapContainer.getExtractors());
    }

    protected boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    protected Object nullifyOldValueIfNecessary(Object oldValue, EntryEventType eventType) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && eventType != EntryEventType.REMOVED) {
            return null;
        }
        return oldValue;
    }

    protected LocalMapStatsImpl getLocalMapStats() {
        LocalMapStatsProvider localMapStatsProvider = this.mapServiceContext.getLocalMapStatsProvider();
        return localMapStatsProvider.getLocalMapStatsImpl(this.name);
    }

    private EntryEventType pickEventTypeOrNull(Map.Entry entry, Object oldValue) {
        Object value = entry.getValue();
        if (value == null) {
            return EntryEventType.REMOVED;
        }
        if (oldValue == null) {
            return EntryEventType.ADDED;
        }
        LazyMapEntry mapEntrySimple = (LazyMapEntry)entry;
        if (mapEntrySimple.isModified()) {
            return EntryEventType.UPDATED;
        }
        return null;
    }

    protected boolean noOp(Map.Entry entry, Object oldValue, long now) {
        if (this.noOp(entry, oldValue)) {
            this.getLocalMapStats().incrementGets(this.getLatencyFrom(now));
            return true;
        }
        return false;
    }

    protected boolean noOp(Map.Entry entry, Object oldValue) {
        LazyMapEntry mapEntrySimple = (LazyMapEntry)entry;
        return !mapEntrySimple.isModified() || oldValue == null && entry.getValue() == null;
    }

    protected boolean entryRemoved(Map.Entry entry, Data key, Object oldValue, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.delete(key);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.doPostOps(key, oldValue, entry);
            return true;
        }
        return false;
    }

    protected boolean entryAddedOrUpdated(Map.Entry entry, Data key, Object oldValue, long now) {
        Object value = entry.getValue();
        if (value != null) {
            this.put(key, value);
            this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
            this.doPostOps(key, oldValue, entry);
            return true;
        }
        return false;
    }

    protected void doPostOps(Data key, Object oldValue, Map.Entry entry) {
        EntryEventType eventType = this.pickEventTypeOrNull(entry, oldValue);
        if (eventType == null) {
            return;
        }
        Object newValue = entry.getValue();
        this.invalidateNearCache(key);
        this.mapServiceContext.interceptAfterPut(this.name, newValue);
        if (this.isPostProcessing(this.recordStore)) {
            Object record = this.recordStore.getRecord(key);
            newValue = record.getValue();
        }
        if (this.mapContainer.isWanReplicationEnabled()) {
            newValue = this.toData(newValue);
            this.publishWanReplicationEvent(key, (Data)newValue, eventType);
        }
        this.publishEntryEvent(key, newValue, oldValue, eventType);
    }

    protected boolean entryRemovedBackup(Map.Entry entry, Data key) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.removeBackup(key);
            return true;
        }
        return false;
    }

    protected boolean entryAddedOrUpdatedBackup(Map.Entry entry, Data key) {
        Object value = entry.getValue();
        if (value != null) {
            this.recordStore.putBackup(key, value);
            return true;
        }
        return false;
    }

    protected void put(Data key, Object value) {
        this.recordStore.set(key, value, -1L);
    }

    protected Object toObject(Object data) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toObject(data);
    }

    protected Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected void publishEntryEvent(Data key, Object value, Object oldValue, EntryEventType eventType) {
        if (this.hasRegisteredListenerForThisMap()) {
            oldValue = this.nullifyOldValueIfNecessary(oldValue, eventType);
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, key, oldValue, value);
        }
    }

    protected void publishWanReplicationEvent(Data key, Data value, EntryEventType eventType) {
        if (EntryEventType.REMOVED == eventType) {
            this.mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
            this.wanEventList.add(new WanEventWrapper(key, null, EntryEventType.REMOVED));
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                Data dataValueAsData = this.toData(value);
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, dataValueAsData, record);
                this.mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
                this.wanEventList.add(new WanEventWrapper(key, value, EntryEventType.UPDATED));
            }
        }
    }

    protected long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    protected Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    protected void processBackup(Map.Entry entry) {
        this.backupProcessor.processBackup(entry);
    }

    protected boolean isKeyProcessable(Data key) {
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        return partitionService.getPartitionId(key) == this.getPartitionId();
    }

    protected boolean isEntryProcessable(Map.Entry entry) {
        return true;
    }

    public void setWanEventList(List<WanEventWrapper> wanEventList) {
        this.wanEventList = wanEventList;
    }

    protected static class WanEventWrapper {
        Data key;
        Data value;
        EntryEventType eventType;

        public WanEventWrapper(Data key, Data value, EntryEventType eventType) {
            this.key = key;
            this.value = value;
            this.eventType = eventType;
        }

        public Data getKey() {
            return this.key;
        }

        public void setKey(Data key) {
            this.key = key;
        }

        public Data getValue() {
            return this.value;
        }

        public void setValue(Data value) {
            this.value = value;
        }

        public EntryEventType getEventType() {
            return this.eventType;
        }

        public void setEventType(EntryEventType eventType) {
            this.eventType = eventType;
        }
    }
}

