/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientInvocationFuture
extends AbstractInvocationFuture<ClientMessage> {
    protected final ClientMessage request;
    private final ClientInvocation invocation;

    public ClientInvocationFuture(ClientInvocation invocation, HazelcastClientInstanceImpl client, ClientMessage request, ILogger logger) {
        super(client.getClientExecutionService(), logger);
        this.request = request;
        this.invocation = invocation;
    }

    @Override
    protected String invocationToString() {
        return this.request.toString();
    }

    @Override
    protected void onInterruptDetected() {
        this.complete(new InterruptedException());
    }

    @Override
    protected TimeoutException newTimeoutException(long timeout, TimeUnit unit) {
        return new TimeoutException();
    }

    @Override
    protected Throwable unwrap(Throwable throwable) {
        return throwable;
    }

    @Override
    protected Object resolve(Object value) {
        if (value instanceof Throwable) {
            return new ExecutionException((Throwable)value);
        }
        return value;
    }

    @Override
    public ClientMessage resolveAndThrow(Object response) throws ExecutionException, InterruptedException {
        if (response instanceof Throwable) {
            ExceptionUtil.fixAsyncStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
            if (response instanceof ExecutionException) {
                throw (ExecutionException)response;
            }
            if (response instanceof Error) {
                throw (Error)response;
            }
            if (response instanceof InterruptedException) {
                throw (InterruptedException)response;
            }
            throw new ExecutionException((Throwable)response);
        }
        return (ClientMessage)response;
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }
}

