/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapValuesCodec;
import com.hazelcast.client.map.impl.nearcache.ClientHeapNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.util.ThreadLocalRandom;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.record.ResultSet;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private volatile NearCache nearCache;
    private volatile String invalidationListenerId;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();
    private int targetPartitionId;

    public ClientReplicatedMapProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onInitialize() {
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        this.targetPartitionId = ThreadLocalRandom.current().nextInt(partitionCount);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapPutCodec.encodeRequest(this.name, keyData, valueData, timeUnit.toMillis(ttl));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        ReplicatedMapPutCodec.ResponseParameters result = ReplicatedMapPutCodec.decodeResponse(response);
        return (V)this.toObject(result.response);
    }

    @Override
    public int size() {
        ClientMessage request = ReplicatedMapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapSizeCodec.ResponseParameters result = ReplicatedMapSizeCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = ReplicatedMapIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapIsEmptyCodec.ResponseParameters result = ReplicatedMapIsEmptyCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapContainsKeyCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        ReplicatedMapContainsKeyCodec.ResponseParameters result = ReplicatedMapContainsKeyCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, NULL_KEY_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = ReplicatedMapContainsValueCodec.encodeRequest(this.name, valueData);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapContainsValueCodec.ResponseParameters result = ReplicatedMapContainsValueCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public V get(Object key) {
        Object cached;
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        if (this.nearCache != null && (cached = this.nearCache.get(key)) != null) {
            if (cached.equals(NearCache.NULL_OBJECT)) {
                return null;
            }
            return cached;
        }
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapGetCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        ReplicatedMapGetCodec.ResponseParameters result = ReplicatedMapGetCodec.decodeResponse(response);
        Object value = this.toObject(result.response);
        if (this.nearCache != null) {
            this.nearCache.put(key, value);
        }
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V remove(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapRemoveCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        ReplicatedMapRemoveCodec.ResponseParameters result = ReplicatedMapRemoveCodec.decodeResponse(response);
        return (V)this.toObject(result.response);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ArrayList<Map.Entry<Data, Data>> dataEntries = new ArrayList<Map.Entry<Data, Data>>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            dataEntries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(this.toData(entry.getKey()), this.toData(entry.getValue())));
        }
        ClientMessage request = ReplicatedMapPutAllCodec.encodeRequest(this.name, dataEntries);
        this.invoke(request);
    }

    @Override
    public void clear() {
        ClientMessage request = ReplicatedMapClearCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener) {
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerCodec(), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerToKeyCodec(keyData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, predicateData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerToKeyWithPredicateCodec(keyData, predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, predicateData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        ClientMessage request = ReplicatedMapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapKeySetCodec.ResponseParameters result = ReplicatedMapKeySetCodec.decodeResponse(response);
        ArrayList keys = new ArrayList(result.response.size());
        for (Data dataKey : result.response) {
            keys.add(new AbstractMap.SimpleImmutableEntry(this.toObject(dataKey), null));
        }
        return new ResultSet(keys, IterationType.KEY);
    }

    @Override
    public LocalReplicatedMapStats getReplicatedMapStats() {
        throw new UnsupportedOperationException("Replicated Map statistics are not available for client !");
    }

    @Override
    public Collection<V> values() {
        ClientMessage request = ReplicatedMapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapValuesCodec.ResponseParameters result = ReplicatedMapValuesCodec.decodeResponse(response);
        return new UnmodifiableLazyList(result.response, this.getSerializationService());
    }

    @Override
    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = ReplicatedMapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapEntrySetCodec.ResponseParameters result = ReplicatedMapEntrySetCodec.decodeResponse(response);
        ArrayList entries = new ArrayList(result.response.size());
        for (Map.Entry<Data, Data> dataEntry : result.response) {
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entries.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return new ResultSet(entries, IterationType.ENTRY);
    }

    private EventHandler<ClientMessage> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            ClientHeapNearCache nearCache;
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            this.nearCache = nearCache = new ClientHeapNearCache(this.name, this.getContext(), nearCacheConfig);
            if (nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            ReplicatedMapAddNearCacheEventHandler handler = new ReplicatedMapAddNearCacheEventHandler();
            this.invalidationListenerId = this.registerListener(this.createNearCacheInvalidationListenerCodec(), handler);
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(ClientHeapNearCache.class);
            logger.severe("-----------------\n Near Cache is not initialized!!! \n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, false, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.invalidationListenerId != null) {
            this.getContext().getListenerService().deregisterListener(this.invalidationListenerId);
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.name + '\'' + '}';
    }

    private class ReplicatedMapAddNearCacheEventHandler
    extends ReplicatedMapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ReplicatedMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void onListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: {
                    ClientReplicatedMapProxy.this.nearCache.remove(ClientReplicatedMapProxy.this.toObject(key));
                    break;
                }
                case CLEAR_ALL: {
                    ClientReplicatedMapProxy.this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)entryEventType));
                }
            }
        }
    }

    private class ReplicatedMapEventHandler
    extends ReplicatedMapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final EntryListener<K, V> listener;

        ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(Data keyData, Data valueData, Data oldValueData, Data mergingValue, int eventTypeId, String uuid, int numberOfAffectedEntries) {
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(uuid);
            EntryEventType eventType = EntryEventType.getByType(eventTypeId);
            DataAwareEntryEvent entryEvent = new DataAwareEntryEvent(member, eventTypeId, ClientReplicatedMapProxy.this.name, keyData, valueData, oldValueData, null, ClientReplicatedMapProxy.this.getContext().getSerializationService());
            switch (eventType) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                case CLEAR_ALL: {
                    MapEvent mapEvent = new MapEvent(ClientReplicatedMapProxy.this.getName(), member, eventTypeId, numberOfAffectedEntries);
                    this.listener.mapCleared(mapEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)eventType));
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

