/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.SelectionHandler;
import java.nio.channels.SelectionKey;

public abstract class AbstractClientSelectionHandler
implements SelectionHandler,
Runnable {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final ClientConnection connection;
    protected final ClientConnectionManager connectionManager;
    @Probe(name="eventCount")
    protected final SwCounter eventCount = SwCounter.newSwCounter();
    private final NonBlockingIOThread ioThread;
    @Probe
    private final int ioThreadId;
    private volatile SelectionKey sk;

    public AbstractClientSelectionHandler(ClientConnection connection, NonBlockingIOThread ioThread, LoggingService loggingService) {
        this.connection = connection;
        this.ioThread = ioThread;
        this.ioThreadId = ioThread.id;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = loggingService.getLogger(this.getClass().getName());
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsInterested() {
        SelectionKey selectionKey = this.sk;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsReady() {
        SelectionKey selectionKey = this.sk;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    protected void shutdown() {
    }

    @Override
    public final void onFailure(Throwable e) {
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connectionManager.destroyConnection(this.connection, null, e);
    }

    final void registerOp(int operation) {
        try {
            if (!this.connection.isAlive()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.keyFor(this.ioThread.getSelector());
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(this.ioThread.getSelector(), operation, this);
            } else {
                this.sk.interestOps(this.sk.interestOps() | operation);
                if (this.sk.attachment() != this) {
                    this.sk.attach(this);
                }
            }
        }
        catch (Throwable e) {
            this.onFailure(e);
        }
    }

    public void register() {
        this.ioThread.addTaskAndWakeup(this);
    }
}

