/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.impl.PartitionReplicaChangeReason;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Arrays;

final class ResetReplicaVersionOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final PartitionReplicaChangeReason reason;

    public ResetReplicaVersionOperation(PartitionReplicaChangeReason reason) {
        this.reason = reason;
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        long[] versions = partitionService.getPartitionReplicaVersions(partitionId);
        versions = Arrays.copyOf(versions, 6);
        int replicaIndex = this.getReplicaIndex();
        versions[replicaIndex - 1] = -1L;
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("SYNC_WAITING flag is set. partitionId=" + partitionId + " replicaIndex=" + replicaIndex + " replicaVersions=" + Arrays.toString(versions) + " reason=" + (Object)((Object)this.reason));
        }
        if (this.reason == PartitionReplicaChangeReason.ASSIGNMENT) {
            this.resetSyncWaitingVersionsAfterReplicaIndex(versions, replicaIndex);
            if (logger.isFinestEnabled()) {
                logger.finest("SYNC_WAITING flags after replica index are reset. partitionId=" + partitionId + " replicaIndex=" + replicaIndex + " replicaVersions=" + Arrays.toString(versions));
            }
        }
        partitionService.clearPartitionReplicaVersions(partitionId);
        partitionService.setPartitionReplicaVersions(partitionId, versions, replicaIndex);
    }

    private void resetSyncWaitingVersionsAfterReplicaIndex(long[] versions, int replicaIndex) {
        for (int i = replicaIndex + 1; i <= versions.length; ++i) {
            if (versions[i - 1] != -1L) continue;
            versions[i - 1] = 0L;
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

