/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnAddressCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientCancellableDelegatingFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;

public class ClientAddressCancellableDelegatingFuture<V>
extends ClientCancellableDelegatingFuture<V> {
    private final Address target;

    public ClientAddressCancellableDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, Address target, V defaultValue, ClientMessageDecoder resultDecoder) {
        super(future, context, uuid, defaultValue, resultDecoder);
        this.target = target;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        boolean cancelSuccessful = false;
        try {
            cancelSuccessful = this.invokeCancelRequest(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (cancelSuccessful) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean e = true;
                return e;
            }
            boolean e = false;
            return e;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.setDone();
        }
    }

    private boolean invokeCancelRequest(boolean mayInterruptIfRunning) throws InterruptedException {
        this.waitForRequestToBeSend();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        ClientMessage request = ExecutorServiceCancelOnAddressCodec.encodeRequest(this.uuid, this.target, mayInterruptIfRunning);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.target);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            return ExecutorServiceCancelOnAddressCodec.decodeResponse((ClientMessage)f.get()).response;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

