/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.extractor.ValueExtractor;
import com.hazelcast.query.impl.DefaultArgumentParser;
import com.hazelcast.query.impl.getters.EvictableGetterCache;
import com.hazelcast.query.impl.getters.ExtractorGetter;
import com.hazelcast.query.impl.getters.ExtractorHelper;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.ReflectionHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Extractors {
    private static final int MAX_CLASSES_IN_CACHE = 1000;
    private static final int MAX_GETTERS_PER_CLASS_IN_CACHE = 100;
    private static final float EVICTION_PERCENTAGE = 0.2f;
    private static final Extractors EMPTY = new Extractors(Collections.<MapAttributeConfig>emptyList());
    private final Map<String, ValueExtractor> extractors;
    private final EvictableGetterCache getterCache;
    private final DefaultArgumentParser argumentsParser;

    public Extractors(List<MapAttributeConfig> mapAttributeConfigs) {
        this.extractors = ExtractorHelper.instantiateExtractors(mapAttributeConfigs);
        this.getterCache = new EvictableGetterCache(1000, 100, 0.2f);
        this.argumentsParser = new DefaultArgumentParser();
    }

    public Object extract(Object targetObject, String attributeName) {
        if (targetObject != null) {
            Getter getter = this.getGetter(targetObject, attributeName);
            try {
                return getter.getValue(targetObject);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new QueryException(ex);
            }
        }
        return null;
    }

    Getter getGetter(Object targetObject, String attributeName) {
        Getter getter = this.getterCache.getGetter(targetObject.getClass(), attributeName);
        if (getter == null && (getter = this.instantiateGetter(targetObject, attributeName)).isCacheable()) {
            this.getterCache.putGetter(targetObject.getClass(), attributeName, getter);
        }
        return getter;
    }

    private Getter instantiateGetter(Object targetObject, String attributeName) {
        String attributeNameWithoutArguments = ExtractorHelper.extractAttributeNameNameWithoutArguments(attributeName);
        ValueExtractor valueExtractor = this.extractors.get(attributeNameWithoutArguments);
        if (valueExtractor != null) {
            Object arguments = this.argumentsParser.parse(ExtractorHelper.extractArgumentsFromAttributeName(attributeName));
            return new ExtractorGetter(valueExtractor, arguments);
        }
        return ReflectionHelper.createGetter(targetObject, attributeName);
    }

    public static Extractors empty() {
        return EMPTY;
    }
}

