/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.EmptyMapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writethrough.WriteThroughStore;
import com.hazelcast.spi.NodeEngine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MapDataStores {
    public static final MapDataStore EMPTY_MAP_DATA_STORE = new EmptyMapDataStore();

    private MapDataStores() {
    }

    public static <K, V> MapDataStore<K, V> createWriteBehindStore(MapStoreContext mapStoreContext, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        int writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
        long writeDelayMillis = TimeUnit.SECONDS.toMillis(writeDelaySeconds);
        boolean writeCoalescing = mapStoreConfig.isWriteCoalescing();
        InMemoryFormat inMemoryFormat = MapDataStores.getInMemoryFormat(mapStoreContext);
        WriteBehindStore mapDataStore = new WriteBehindStore(store, serializationService, writeDelayMillis, partitionId, inMemoryFormat, writeCoalescing);
        WriteBehindQueue writeBehindQueue = MapDataStores.newWriteBehindQueue(mapServiceContext, writeCoalescing);
        mapDataStore.setWriteBehindQueue(writeBehindQueue);
        mapDataStore.setWriteBehindProcessor(writeBehindProcessor);
        return mapDataStore;
    }

    private static InMemoryFormat getInMemoryFormat(MapStoreContext mapStoreContext) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        Config config = nodeEngine.getConfig();
        String mapName = mapStoreContext.getMapName();
        MapConfig mapConfig = config.findMapConfig(mapName);
        return mapConfig.getInMemoryFormat();
    }

    private static WriteBehindQueue newWriteBehindQueue(MapServiceContext mapServiceContext, boolean writeCoalescing) {
        GroupProperties groupProperties = mapServiceContext.getNodeEngine().getGroupProperties();
        int capacity = groupProperties.getInteger(GroupProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY);
        AtomicInteger counter = mapServiceContext.getWriteBehindQueueItemCounter();
        return writeCoalescing ? WriteBehindQueues.createDefaultWriteBehindQueue() : WriteBehindQueues.createBoundedWriteBehindQueue(capacity, counter);
    }

    public static <K, V> MapDataStore<K, V> createWriteThroughStore(MapStoreContext mapStoreContext) {
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        return new WriteThroughStore(store, serializationService);
    }

    public static <K, V> MapDataStore<K, V> emptyStore() {
        return EMPTY_MAP_DATA_STORE;
    }
}

