/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.MemoryInfoAccessor;
import com.hazelcast.util.RuntimeMemoryInfoAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EvictionCheckerImpl
implements EvictionChecker {
    protected static final int ONE_HUNDRED_PERCENT = 100;
    protected static final int ONE_KILOBYTE = 1024;
    protected static final int ONE_MEGABYTE = 0x100000;
    protected final MapServiceContext mapServiceContext;
    protected MemoryInfoAccessor memoryInfoAccessor = new RuntimeMemoryInfoAccessor();

    public EvictionCheckerImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public boolean checkEvictionPossible(RecordStore recordStore) {
        boolean result;
        String mapName = recordStore.getName();
        int partitionId = recordStore.getPartitionId();
        MapContainer mapContainer = recordStore.getMapContainer();
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        MaxSizeConfig.MaxSizePolicy maxSizePolicy = maxSizeConfig.getMaxSizePolicy();
        switch (maxSizePolicy) {
            case PER_NODE: {
                result = this.checkPerNodeEviction(recordStore);
                break;
            }
            case PER_PARTITION: {
                result = this.checkPerPartitionEviction(mapName, maxSizeConfig, partitionId);
                break;
            }
            case USED_HEAP_PERCENTAGE: {
                result = this.checkHeapPercentageEviction(mapName, maxSizeConfig);
                break;
            }
            case USED_HEAP_SIZE: {
                result = this.checkHeapSizeEviction(mapName, maxSizeConfig);
                break;
            }
            case FREE_HEAP_PERCENTAGE: {
                result = this.checkFreeHeapPercentageEviction(maxSizeConfig);
                break;
            }
            case FREE_HEAP_SIZE: {
                result = this.checkFreeHeapSizeEviction(maxSizeConfig);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate max size policy [" + (Object)((Object)maxSizePolicy) + ']');
            }
        }
        return result;
    }

    protected boolean checkPerNodeEviction(RecordStore recordStore) {
        double maxExpectedRecordStoreSize = this.calculatePerNodeMaxRecordStoreSize(recordStore);
        return (double)recordStore.size() > maxExpectedRecordStoreSize;
    }

    public double calculatePerNodeMaxRecordStoreSize(RecordStore recordStore) {
        MapConfig mapConfig = recordStore.getMapContainer().getMapConfig();
        MaxSizeConfig maxSizeConfig = mapConfig.getMaxSizeConfig();
        int configuredMaxSize = maxSizeConfig.getSize();
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        int memberCount = nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
        return 1.0 * (double)configuredMaxSize * (double)memberCount / (double)partitionCount;
    }

    protected boolean checkPerPartitionEviction(String mapName, MaxSizeConfig maxSizeConfig, int partitionId) {
        double maxSize = maxSizeConfig.getSize();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
        if (container == null) {
            return false;
        }
        int size = this.getRecordStoreSize(mapName, container);
        return (double)size >= maxSize;
    }

    protected boolean checkHeapSizeEviction(String mapName, MaxSizeConfig maxSizeConfig) {
        long usedHeapSize = this.getUsedHeapSize(mapName);
        if (usedHeapSize == -1L) {
            return false;
        }
        double maxSize = maxSizeConfig.getSize();
        return maxSize < 1.0 * (double)usedHeapSize / 1048576.0;
    }

    protected boolean checkFreeHeapSizeEviction(MaxSizeConfig maxSizeConfig) {
        long currentFreeHeapSize = this.getAvailableMemory();
        double minFreeHeapSize = maxSizeConfig.getSize();
        return minFreeHeapSize > 1.0 * (double)currentFreeHeapSize / 1048576.0;
    }

    protected boolean checkHeapPercentageEviction(String mapName, MaxSizeConfig maxSizeConfig) {
        long total;
        long usedHeapSize = this.getUsedHeapSize(mapName);
        if (usedHeapSize == -1L) {
            return false;
        }
        double maxSize = maxSizeConfig.getSize();
        return maxSize < 100.0 * (double)usedHeapSize / (double)(total = this.getTotalMemory());
    }

    protected boolean checkFreeHeapPercentageEviction(MaxSizeConfig maxSizeConfig) {
        long total;
        long currentFreeHeapSize = this.getAvailableMemory();
        double freeHeapPercentage = maxSizeConfig.getSize();
        return freeHeapPercentage > 100.0 * (double)currentFreeHeapSize / (double)(total = this.getTotalMemory());
    }

    protected long getTotalMemory() {
        return this.memoryInfoAccessor.getTotalMemory();
    }

    protected long getFreeMemory() {
        return this.memoryInfoAccessor.getFreeMemory();
    }

    protected long getMaxMemory() {
        return this.memoryInfoAccessor.getMaxMemory();
    }

    protected long getAvailableMemory() {
        long totalMemory = this.getTotalMemory();
        long freeMemory = this.getFreeMemory();
        long maxMemory = this.getMaxMemory();
        return freeMemory + (maxMemory - totalMemory);
    }

    protected long getUsedHeapSize(String mapName) {
        long heapCost = 0L;
        List<Integer> partitionIds = this.findPartitionIds();
        for (int partitionId : partitionIds) {
            PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
            if (container == null) continue;
            heapCost += this.getRecordStoreHeapCost(mapName, container);
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return heapCost += mapContainer.getNearCacheSizeEstimator().getSize();
    }

    protected int getRecordStoreSize(String mapName, PartitionContainer partitionContainer) {
        RecordStore existingRecordStore = partitionContainer.getExistingRecordStore(mapName);
        if (existingRecordStore == null) {
            return 0;
        }
        return existingRecordStore.size();
    }

    protected long getRecordStoreHeapCost(String mapName, PartitionContainer partitionContainer) {
        RecordStore existingRecordStore = partitionContainer.getExistingRecordStore(mapName);
        if (existingRecordStore == null) {
            return 0L;
        }
        return existingRecordStore.getHeapCost();
    }

    protected List<Integer> findPartitionIds() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        ArrayList<Integer> partitionIds = null;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (!this.isOwnerOrBackup(partitionId)) continue;
            if (partitionIds == null) {
                partitionIds = new ArrayList<Integer>();
            }
            partitionIds.add(partitionId);
        }
        return partitionIds == null ? Collections.emptyList() : partitionIds;
    }

    protected boolean isOwnerOrBackup(int partitionId) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        Address thisAddress = nodeEngine.getThisAddress();
        return partition.isOwnerOrBackup(thisAddress);
    }

    public void setMemoryInfoAccessor(MemoryInfoAccessor memoryInfoAccessor) {
        this.memoryInfoAccessor = memoryInfoAccessor;
    }
}

