/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.entryprocessor;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.JvmIdAware;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Map;

public final class GetAttributeEntryProcessor
implements EntryProcessor<String, SessionState>,
IdentifiedDataSerializable,
JvmIdAware {
    String attributeName;
    private String jvmId;

    public GetAttributeEntryProcessor(String attributeName) {
        this.attributeName = attributeName;
    }

    public GetAttributeEntryProcessor() {
        this(null);
    }

    @Override
    public void setJvmId(String jvmId) {
        this.jvmId = jvmId;
    }

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    public Data process(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState == null) {
            return null;
        }
        sessionState.addJvmId(this.jvmId);
        entry.setValue(sessionState);
        return sessionState.getAttributes().get(this.attributeName);
    }

    @Override
    public EntryBackupProcessor<String, SessionState> getBackupProcessor() {
        return null;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readUTF();
        this.jvmId = in.readUTF();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributeName);
        out.writeUTF(this.jvmId);
    }
}

