/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.entryprocessor;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.JvmIdAware;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Map;

public final class DeleteSessionEntryProcessor
implements EntryProcessor<String, SessionState>,
EntryBackupProcessor<String, SessionState>,
IdentifiedDataSerializable,
JvmIdAware {
    private String jvmId;
    private boolean invalidate;
    private boolean removed;

    public DeleteSessionEntryProcessor(String jvmId, boolean invalidate) {
        this.jvmId = jvmId;
        this.invalidate = invalidate;
    }

    public DeleteSessionEntryProcessor() {
    }

    @Override
    public void setJvmId(String jvmId) {
        this.jvmId = jvmId;
    }

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public Object process(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState == null) {
            return Boolean.FALSE;
        }
        sessionState.removeJvmId(this.jvmId);
        if (this.invalidate || sessionState.getJvmIds().isEmpty()) {
            entry.setValue(null);
            this.removed = true;
        } else {
            entry.setValue(sessionState);
        }
        return Boolean.TRUE;
    }

    @Override
    public EntryBackupProcessor<String, SessionState> getBackupProcessor() {
        return this.removed ? this : null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.jvmId);
        out.writeBoolean(this.invalidate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jvmId = in.readUTF();
        this.invalidate = in.readBoolean();
    }

    @Override
    public void processBackup(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState != null) {
            entry.setValue(null);
        }
    }
}

