/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CacheConcurrentHashMap<K, V>
extends ConcurrentReferenceHashMap<K, V> {
    private static final float LOAD_FACTOR = 0.91f;

    public CacheConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.91f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, null);
    }

    public CacheConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
    }

    public CacheKeyIteratorResult fetchNext(int nextTableIndex, int size) {
        ArrayList<Data> keys = new ArrayList<Data>();
        int tableIndex = this.fetch(nextTableIndex, size, keys);
        return new CacheKeyIteratorResult(keys, tableIndex);
    }

    int fetch(int tableIndex, int size, List<Data> keys) {
        long now = Clock.currentTimeMillis();
        ConcurrentReferenceHashMap.Segment segment = this.segments[0];
        ConcurrentReferenceHashMap.HashEntry<K, V>[] currentTable = segment.table;
        int nextTableIndex = tableIndex >= 0 && tableIndex < segment.table.length ? tableIndex : currentTable.length - 1;
        int counter = 0;
        while (nextTableIndex >= 0 && counter < size) {
            ConcurrentReferenceHashMap.HashEntry nextEntry = currentTable[nextTableIndex--];
            while (nextEntry != null) {
                if (nextEntry.key() != null) {
                    boolean isExpired;
                    Object value = nextEntry.value();
                    boolean bl = isExpired = value instanceof Expirable && ((Expirable)value).isExpiredAt(now);
                    if (!isExpired) {
                        keys.add((Data)nextEntry.key());
                        ++counter;
                    }
                }
                nextEntry = nextEntry.next;
            }
        }
        return nextTableIndex;
    }
}

