/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.spring.context.SpringManagedContext;
import com.hazelcast.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractHazelcastBeanDefinitionParser
extends AbstractBeanDefinitionParser {

    public abstract class SpringXmlBuilderHelper
    extends AbstractXmlConfigHelper {
        protected BeanDefinitionBuilder configBuilder;

        protected void handleCommonBeanAttributes(Node node, BeanDefinitionBuilder builder, ParserContext parserContext) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                Node lazyInitAttr = attributes.getNamedItem("lazy-init");
                if (lazyInitAttr != null) {
                    builder.setLazyInit(Boolean.valueOf(this.getTextContent(lazyInitAttr)).booleanValue());
                } else {
                    builder.setLazyInit(parserContext.isDefaultLazyInit());
                }
                if (parserContext.isNested()) {
                    builder.setScope(parserContext.getContainingBeanDefinition().getScope());
                } else {
                    Node scopeNode = attributes.getNamedItem("scope");
                    if (scopeNode != null) {
                        builder.setScope(this.getTextContent(scopeNode));
                    }
                }
                Node dependsOnNode = attributes.getNamedItem("depends-on");
                if (dependsOnNode != null) {
                    String[] dependsOn;
                    for (String dep : dependsOn = this.getTextContent(dependsOnNode).split("[,;]")) {
                        builder.addDependsOn(dep.trim());
                    }
                }
            }
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            builder.setScope(this.configBuilder.getBeanDefinition().getScope());
            builder.setLazyInit(this.configBuilder.getBeanDefinition().isLazyInit());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected void createAndFillListedBean(Node node, Class clazz, String propertyName, ManagedMap managedMap, String ... excludeNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem(propertyName);
            String name = this.getTextContent(attName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, excludeNames);
            managedMap.put((Object)name, (Object)beanDefinition);
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : SpringXmlBuilderHelper.childElements(node)) {
                String name = this.xmlToJavaName(SpringXmlBuilderHelper.cleanNodeName(n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getTextContent(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        protected ManagedList parseListeners(Node node, Class listenerConfigClass) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : SpringXmlBuilderHelper.childElements(node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(listenerConfigClass);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, "implementation");
                Node implementationNode = listenerNode.getAttributes().getNamedItem("implementation");
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference("implementation", this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        protected ManagedList parseProxyFactories(Node node, Class proxyFactoryConfigClass) {
            ManagedList list = new ManagedList();
            for (Node instanceNode : SpringXmlBuilderHelper.childElements(node)) {
                BeanDefinitionBuilder confBuilder = this.createBeanBuilder(proxyFactoryConfigClass);
                this.fillAttributeValues(instanceNode, confBuilder, new String[0]);
                list.add((Object)confBuilder.getBeanDefinition());
            }
            return list;
        }

        protected void handleDataSerializableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : SpringXmlBuilderHelper.childElements(node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName(child);
                if (!"data-serializable-factory".equals(name)) continue;
                NamedNodeMap attrs = child.getAttributes();
                Node implRef = attrs.getNamedItem("implementation");
                Node classNode = attrs.getNamedItem("class-name");
                Node fidNode = attrs.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("dataSerializableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("dataSerializableFactories", (Object)factories);
        }

        protected void handleSerializers(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = null;
            String implementation = "implementation";
            String className = "class-name";
            String typeClassName = "type-class";
            ManagedList serializers = new ManagedList();
            for (Node child : SpringXmlBuilderHelper.childElements(node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName(child);
                if ("global-serializer".equals(name)) {
                    globalSerializerConfigBuilder = this.createGSConfigBuilder(GlobalSerializerConfig.class, child, implementation, className);
                }
                if (!"serializer".equals(name)) continue;
                BeanDefinitionBuilder serializerConfigBuilder = this.createBeanBuilder(SerializerConfig.class);
                this.fillAttributeValues(child, serializerConfigBuilder, new String[0]);
                NamedNodeMap attrs = child.getAttributes();
                Node implRef = attrs.getNamedItem(implementation);
                Node classNode = attrs.getNamedItem(className);
                Node typeClass = attrs.getNamedItem(typeClassName);
                if (typeClass != null) {
                    serializerConfigBuilder.addPropertyValue("typeClassName", (Object)this.getTextContent(typeClass));
                }
                if (implRef != null) {
                    serializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
                }
                if (classNode != null) {
                    serializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
                }
                serializers.add((Object)serializerConfigBuilder.getBeanDefinition());
            }
            if (globalSerializerConfigBuilder != null) {
                serializationConfigBuilder.addPropertyValue("globalSerializerConfig", (Object)globalSerializerConfigBuilder.getBeanDefinition());
            }
            serializationConfigBuilder.addPropertyValue("serializerConfigs", (Object)serializers);
        }

        private BeanDefinitionBuilder createGSConfigBuilder(Class<GlobalSerializerConfig> globalSerializerConfigClass, Node child, String implementation, String className) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = this.createBeanBuilder(globalSerializerConfigClass);
            NamedNodeMap attrs = child.getAttributes();
            Node implRef = attrs.getNamedItem(implementation);
            Node classNode = attrs.getNamedItem(className);
            if (implRef != null) {
                globalSerializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
            }
            if (classNode != null) {
                globalSerializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
            }
            return globalSerializerConfigBuilder;
        }

        protected void handlePortableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : SpringXmlBuilderHelper.childElements(node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName(child);
                if (!"portable-factory".equals(name)) continue;
                NamedNodeMap attrs = child.getAttributes();
                Node implRef = attrs.getNamedItem("implementation");
                Node classNode = attrs.getNamedItem("class-name");
                Node fidNode = attrs.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("portableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("portableFactories", (Object)factories);
        }

        protected void handleSerialization(Node node) {
            BeanDefinitionBuilder serializationConfigBuilder = this.createBeanBuilder(SerializationConfig.class);
            AbstractBeanDefinition beanDefinition = serializationConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serializationConfigBuilder, new String[0]);
            for (Node child : SpringXmlBuilderHelper.childElements(node)) {
                String nodeName = SpringXmlBuilderHelper.cleanNodeName(child);
                if ("data-serializable-factories".equals(nodeName)) {
                    this.handleDataSerializableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if ("portable-factories".equals(nodeName)) {
                    this.handlePortableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if (!"serializers".equals(nodeName)) continue;
                this.handleSerializers(child, serializationConfigBuilder);
            }
            this.configBuilder.addPropertyValue("serializationConfig", (Object)beanDefinition);
        }

        protected void handleSocketInterceptorConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder socketInterceptorConfigBuilder = this.createBeanBuilder(SocketInterceptorConfig.class);
            String implAttribute = "implementation";
            this.fillAttributeValues(node, socketInterceptorConfigBuilder, "implementation");
            Node implNode = node.getAttributes().getNamedItem("implementation");
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                socketInterceptorConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), implementation);
            }
            for (Node child : SpringXmlBuilderHelper.childElements(node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, socketInterceptorConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("socketInterceptorConfig", (Object)socketInterceptorConfigBuilder.getBeanDefinition());
        }

        protected void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = new ManagedMap();
            for (Node n : SpringXmlBuilderHelper.childElements(node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName(n);
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getTextContent(n);
                properties.put((Object)propertyName, (Object)value);
            }
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        protected void handleSpringAware() {
            BeanDefinitionBuilder managedContextBeanBuilder = this.createBeanBuilder(SpringManagedContext.class);
            this.configBuilder.addPropertyValue("managedContext", (Object)managedContextBeanBuilder.getBeanDefinition());
        }

        protected EvictionConfig getEvictionConfig(Node node) {
            EvictionConfig evictionConfig = new EvictionConfig();
            Node size = node.getAttributes().getNamedItem("size");
            Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
            Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
            if (size != null) {
                evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
            }
            if (maxSizePolicy != null) {
                evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
            }
            if (evictionPolicy != null) {
                evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
            }
            return evictionConfig;
        }
    }
}

