/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.NodeState;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationservice.impl.InternalResponse;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationutil.Operations;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;

abstract class Invocation
implements OperationResponseHandler,
Runnable {
    private static final AtomicReferenceFieldUpdater<Invocation, Boolean> RESPONSE_RECEIVED = AtomicReferenceFieldUpdater.newUpdater(Invocation.class, Boolean.class, "responseReceived");
    private static final AtomicIntegerFieldUpdater<Invocation> BACKUPS_COMPLETED = AtomicIntegerFieldUpdater.newUpdater(Invocation.class, "backupsCompleted");
    private static final long MIN_TIMEOUT = 10000L;
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    private static final int LOG_MAX_INVOCATION_COUNT = 99;
    private static final int LOG_INVOCATION_COUNT_MOD = 10;
    volatile long pendingResponseReceivedMillis = -1L;
    volatile Object pendingResponse;
    volatile int backupsExpected;
    volatile int backupsCompleted;
    volatile Boolean responseReceived = Boolean.FALSE;
    final long callTimeout;
    final NodeEngineImpl nodeEngine;
    final String serviceName;
    final Operation op;
    final int partitionId;
    final int replicaIndex;
    final int tryCount;
    final long tryPauseMillis;
    final ILogger logger;
    final boolean resultDeserialized;
    boolean remote;
    Address invTarget;
    MemberImpl targetMember;
    final InvocationFuture invocationFuture;
    final OperationServiceImpl operationService;
    volatile int invokeCount;

    Invocation(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, int replicaIndex, int tryCount, long tryPauseMillis, long callTimeout, ExecutionCallback callback, boolean resultDeserialized) {
        this.operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        this.logger = this.operationService.invocationLogger;
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.tryCount = tryCount;
        this.tryPauseMillis = tryPauseMillis;
        this.callTimeout = this.getCallTimeout(callTimeout);
        this.invocationFuture = new InvocationFuture(this.operationService, this, callback);
        this.resultDeserialized = resultDeserialized;
    }

    abstract ExceptionAction onException(Throwable var1);

    protected abstract Address getTarget();

    InternalPartition getPartition() {
        return this.nodeEngine.getPartitionService().getPartition(this.partitionId);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    private long getCallTimeout(long callTimeout) {
        if (callTimeout > 0L) {
            return callTimeout;
        }
        long defaultCallTimeout = this.operationService.defaultCallTimeoutMillis;
        if (!(this.op instanceof WaitSupport)) {
            return defaultCallTimeout;
        }
        long waitTimeoutMillis = this.op.getWaitTimeout();
        if (waitTimeoutMillis > 0L && waitTimeoutMillis < Long.MAX_VALUE) {
            long max = Math.max(waitTimeoutMillis, 10000L);
            return Math.min(max, defaultCallTimeout);
        }
        return defaultCallTimeout;
    }

    public final InvocationFuture invoke() {
        this.invokeInternal(false);
        return this.invocationFuture;
    }

    public final void invokeAsync() {
        this.invokeInternal(true);
    }

    private void invokeInternal(boolean isAsync) {
        if (this.invokeCount > 0) {
            throw new IllegalStateException("An invocation can not be invoked more than once!");
        }
        if (this.op.getCallId() != 0L) {
            throw new IllegalStateException("An operation[" + this.op + "] can not be used for multiple invocations!");
        }
        try {
            OperationAccessor.setCallTimeout(this.op, this.callTimeout);
            OperationAccessor.setCallerAddress(this.op, this.nodeEngine.getThisAddress());
            this.op.setNodeEngine(this.nodeEngine).setServiceName(this.serviceName).setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex);
            boolean isAllowed = this.operationService.operationExecutor.isInvocationAllowedFromCurrentThread(this.op, isAsync);
            if (!isAllowed && !Operations.isMigrationOperation(this.op)) {
                throw new IllegalThreadStateException(Thread.currentThread() + " cannot make remote call: " + this.op);
            }
            this.doInvoke(isAsync);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
    }

    private void handleInvocationException(Exception e) {
        if (!(e instanceof RetryableException)) {
            throw ExceptionUtil.rethrow(e);
        }
        this.notify(e);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only a single thread at any given time can change the volatile field")
    private void doInvoke(boolean isAsync) {
        if (!this.engineActive()) {
            return;
        }
        ++this.invokeCount;
        if (!this.initInvocationTarget()) {
            return;
        }
        OperationAccessor.setInvocationTime(this.op, this.nodeEngine.getClusterService().getClusterClock().getClusterTime());
        this.operationService.invocationsRegistry.register(this);
        if (this.remote) {
            this.doInvokeRemote();
        } else {
            this.doInvokeLocal(isAsync);
        }
    }

    private void doInvokeLocal(boolean isAsync) {
        if (this.op.getCallerUuid() == null) {
            this.op.setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
        }
        this.responseReceived = Boolean.FALSE;
        this.op.setOperationResponseHandler(this);
        OperationExecutor executor = this.operationService.operationExecutor;
        if (isAsync) {
            executor.execute(this.op);
        } else {
            executor.runOnCallingThreadIfPossible(this.op);
        }
    }

    private void doInvokeRemote() {
        boolean sent = this.operationService.send(this.op, this.invTarget);
        if (!sent) {
            this.operationService.invocationsRegistry.deregister(this);
            this.notify(new RetryableIOException("Packet not send to -> " + this.invTarget));
        }
    }

    @Override
    public void run() {
        this.doInvoke(false);
    }

    private boolean engineActive() {
        boolean allowed;
        if (this.nodeEngine.isRunning()) {
            return true;
        }
        NodeState state = this.nodeEngine.getNode().getState();
        boolean bl = allowed = state == NodeState.PASSIVE && this.op instanceof AllowedDuringPassiveState;
        if (!allowed) {
            this.notify(new HazelcastInstanceNotActiveException("State: " + (Object)((Object)state) + " Operation: " + this.op.getClass()));
            this.remote = false;
        }
        return allowed;
    }

    boolean initInvocationTarget() {
        Address thisAddress = this.nodeEngine.getThisAddress();
        this.invTarget = this.getTarget();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        if (this.invTarget == null) {
            this.remote = false;
            this.notifyWithExceptionWhenTargetIsNull();
            return false;
        }
        this.targetMember = clusterService.getMember(this.invTarget);
        if (this.targetMember == null && !Operations.isJoinOperation(this.op) && !Operations.isWanReplicationOperation(this.op)) {
            this.notify(new TargetNotMemberException(this.invTarget, this.partitionId, this.op.getClass().getName(), this.serviceName));
            return false;
        }
        if (this.op.getPartitionId() != this.partitionId) {
            this.notify(new IllegalStateException("Partition id of operation: " + this.op.getPartitionId() + " is not equal to the partition id of invocation: " + this.partitionId));
            return false;
        }
        if (this.op.getReplicaIndex() != this.replicaIndex) {
            this.notify(new IllegalStateException("Replica index of operation: " + this.op.getReplicaIndex() + " is not equal to the replica index of invocation: " + this.replicaIndex));
            return false;
        }
        this.remote = !thisAddress.equals(this.invTarget);
        return true;
    }

    private void notifyWithExceptionWhenTargetIsNull() {
        Address thisAddress = this.nodeEngine.getThisAddress();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        if (!this.nodeEngine.isRunning()) {
            this.notify(new HazelcastInstanceNotActiveException());
            return;
        }
        ClusterState clusterState = clusterService.getClusterState();
        if (clusterState == ClusterState.FROZEN || clusterState == ClusterState.PASSIVE) {
            this.notify(new IllegalStateException("Partitions can't be assigned since cluster-state: " + (Object)((Object)clusterState)));
            return;
        }
        if (clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) == 0) {
            NoDataMemberInClusterException exception = new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            this.notify(exception);
            return;
        }
        this.notify(new WrongTargetException(thisAddress, null, this.partitionId, this.replicaIndex, this.op.getClass().getName(), this.serviceName));
    }

    public void sendResponse(Operation op, Object obj) {
        if (!RESPONSE_RECEIVED.compareAndSet(this, Boolean.FALSE, Boolean.TRUE)) {
            throw new ResponseAlreadySentException("NormalResponse already responseReceived for callback: " + this + ", current-response: : " + obj);
        }
        this.notify(obj);
    }

    void notify(Object response) {
        if (response == null) {
            response = InternalResponse.NULL_RESPONSE;
        }
        if (response instanceof CallTimeoutResponse) {
            this.notifyCallTimeout();
            return;
        }
        if (response instanceof ErrorResponse || response instanceof Throwable) {
            this.notifyError(response);
            return;
        }
        if (response instanceof NormalResponse) {
            NormalResponse normalResponse = (NormalResponse)response;
            this.notifyNormalResponse(normalResponse.getValue(), normalResponse.getBackupCount());
            return;
        }
        this.invocationFuture.set(response);
    }

    void notifyError(Object error) {
        assert (error != null);
        Throwable cause = error instanceof Throwable ? (Throwable)error : ((ErrorResponse)error).getCause();
        switch (this.onException(cause)) {
            case CONTINUE_WAIT: {
                this.handleContinueWait();
                break;
            }
            case THROW_EXCEPTION: {
                this.notifyNormalResponse(cause, 0);
                break;
            }
            case RETRY_INVOCATION: {
                if (this.invokeCount < this.tryCount) {
                    this.handleRetry(cause);
                    break;
                }
                this.notifyNormalResponse(cause, 0);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled ExceptionAction");
            }
        }
    }

    void notifyNormalResponse(Object value, int expectedBackups) {
        if (value == null) {
            value = InternalResponse.NULL_RESPONSE;
        }
        if (expectedBackups > this.backupsCompleted) {
            this.pendingResponseReceivedMillis = Clock.currentTimeMillis();
            this.backupsExpected = expectedBackups;
            this.pendingResponse = value;
            if (this.backupsCompleted != expectedBackups) {
                return;
            }
        }
        this.invocationFuture.set(value);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only a single thread at any given time can change the volatile field")
    void notifyCallTimeout() {
        this.operationService.callTimeoutCount.inc();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Call timed-out either in operation queue or during wait-notify phase, retrying call: " + this.toString());
        }
        if (this.op instanceof WaitSupport) {
            long waitTimeout = this.op.getWaitTimeout();
            this.op.setWaitTimeout(waitTimeout -= this.callTimeout);
        }
        --this.invokeCount;
        this.handleRetry("invocation timeout");
    }

    void notifySingleBackupComplete() {
        int newBackupsCompleted = BACKUPS_COMPLETED.incrementAndGet(this);
        Object pendingResponse = this.pendingResponse;
        if (pendingResponse == null) {
            return;
        }
        int backupsExpected = this.backupsExpected;
        if (backupsExpected < newBackupsCompleted) {
            return;
        }
        if (backupsExpected != newBackupsCompleted) {
            return;
        }
        this.invocationFuture.set(pendingResponse);
    }

    boolean checkInvocationTimeout() {
        boolean notExpired;
        long maxCallTimeout = this.invocationFuture.getMaxCallTimeout();
        long expirationTime = this.op.getInvocationTime() + maxCallTimeout;
        boolean hasResponse = this.pendingResponse != null;
        boolean hasWaitingThreads = this.invocationFuture.getWaitingThreadsCount() > 0;
        boolean bl = notExpired = maxCallTimeout == Long.MAX_VALUE || expirationTime < 0L || expirationTime >= Clock.currentTimeMillis();
        if (hasResponse || hasWaitingThreads || notExpired) {
            return false;
        }
        this.operationService.getIsStillRunningService().timeoutInvocationIfNotExecuting(this);
        return true;
    }

    Object newOperationTimeoutException(long totalTimeoutMs) {
        this.operationService.operationTimeoutCount.inc();
        boolean hasResponse = this.pendingResponse != null;
        int backupsExpected = this.backupsExpected;
        int backupsCompleted = this.backupsCompleted;
        if (hasResponse) {
            return new OperationTimeoutException("No response for " + totalTimeoutMs + " ms." + " Aborting invocation! " + this.toString() + " Not all backups have completed! " + " backups-expected:" + backupsExpected + " backups-completed: " + backupsCompleted);
        }
        return new OperationTimeoutException("No response for " + totalTimeoutMs + " ms." + " Aborting invocation! " + this.toString() + " No response has been received! " + " backups-expected:" + backupsExpected + " backups-completed: " + backupsCompleted);
    }

    private void handleContinueWait() {
        this.invocationFuture.set(InternalResponse.WAIT_RESPONSE);
    }

    private void handleRetry(Object cause) {
        this.operationService.retryCount.inc();
        if (this.invokeCount % 10 == 0) {
            Level level;
            Level level2 = level = this.invokeCount > 99 ? Level.WARNING : Level.FINEST;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, "Retrying invocation: " + this.toString() + ", Reason: " + cause);
            }
        }
        this.operationService.invocationsRegistry.deregister(this);
        if (this.invocationFuture.interrupted) {
            this.invocationFuture.set(InternalResponse.INTERRUPTED_RESPONSE);
            return;
        }
        if (!this.invocationFuture.set(InternalResponse.WAIT_RESPONSE)) {
            this.logger.finest("Cannot retry " + this.toString() + ", because a different response is already set: " + this.invocationFuture.response);
            return;
        }
        InternalExecutionService ex = this.nodeEngine.getExecutionService();
        if (this.invokeCount < 5) {
            this.operationService.asyncExecutor.execute(this);
        } else {
            ex.schedule("hz:async", this, this.tryPauseMillis, TimeUnit.MILLISECONDS);
        }
    }

    boolean checkBackupTimeout(long timeoutMillis) {
        boolean targetDead;
        boolean responseReceived;
        boolean allBackupsComplete = this.backupsExpected == this.backupsCompleted;
        long responseReceivedMillis = this.pendingResponseReceivedMillis;
        long expirationTime = responseReceivedMillis + timeoutMillis;
        boolean timeout = expirationTime > 0L && expirationTime < Clock.currentTimeMillis();
        boolean bl = responseReceived = this.pendingResponse != null;
        if (allBackupsComplete || !responseReceived || !timeout) {
            return false;
        }
        boolean bl2 = targetDead = this.nodeEngine.getClusterService().getMember(this.invTarget) == null;
        if (targetDead) {
            this.resetAndReInvoke();
            return false;
        }
        this.invocationFuture.set(this.pendingResponse);
        return true;
    }

    private void resetAndReInvoke() {
        this.operationService.invocationsRegistry.deregister(this);
        this.invokeCount = 0;
        this.pendingResponse = null;
        this.pendingResponseReceivedMillis = -1L;
        this.backupsExpected = 0;
        this.backupsCompleted = 0;
        this.doInvoke(false);
    }

    public String toString() {
        String connectionStr = null;
        Address invTarget = this.invTarget;
        if (invTarget != null) {
            ConnectionManager connectionManager = this.operationService.nodeEngine.getNode().getConnectionManager();
            Connection connection = connectionManager.getConnection(invTarget);
            connectionStr = connection == null ? null : connection.toString();
        }
        return "Invocation{serviceName='" + this.serviceName + '\'' + ", op=" + this.op + ", partitionId=" + this.partitionId + ", replicaIndex=" + this.replicaIndex + ", tryCount=" + this.tryCount + ", tryPauseMillis=" + this.tryPauseMillis + ", invokeCount=" + this.invokeCount + ", callTimeout=" + this.callTimeout + ", target=" + invTarget + ", backupsExpected=" + this.backupsExpected + ", backupsCompleted=" + this.backupsCompleted + ", connection=" + connectionStr + '}';
    }
}

