/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.classic;

import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationexecutor.OperationRunnerFactory;
import com.hazelcast.spi.impl.operationexecutor.classic.DefaultScheduleQueue;
import com.hazelcast.spi.impl.operationexecutor.classic.GenericOperationThread;
import com.hazelcast.spi.impl.operationexecutor.classic.OperationThread;
import com.hazelcast.spi.impl.operationexecutor.classic.PartitionOperationThread;
import com.hazelcast.spi.impl.operationexecutor.classic.ScheduleQueue;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;

public final class ClassicOperationExecutor
implements OperationExecutor {
    public static final int TERMINATION_TIMEOUT_SECONDS = 3;
    private final ILogger logger;
    private final PartitionOperationThread[] partitionOperationThreads;
    private final OperationRunner[] partitionOperationRunners;
    private final ScheduleQueue genericScheduleQueue;
    private final GenericOperationThread[] genericOperationThreads;
    private final OperationRunner[] genericOperationRunners;
    private final Address thisAddress;
    private final NodeExtension nodeExtension;
    private final HazelcastThreadGroup threadGroup;
    private final OperationRunner adHocOperationRunner;
    private final MetricsRegistry metricsRegistry;

    public ClassicOperationExecutor(GroupProperties properties, LoggingService loggerService, Address thisAddress, OperationRunnerFactory operationRunnerFactory, HazelcastThreadGroup hazelcastThreadGroup, NodeExtension nodeExtension, MetricsRegistry metricsRegistry) {
        this.thisAddress = thisAddress;
        this.nodeExtension = nodeExtension;
        this.threadGroup = hazelcastThreadGroup;
        this.metricsRegistry = metricsRegistry;
        this.logger = loggerService.getLogger(ClassicOperationExecutor.class);
        this.genericScheduleQueue = new DefaultScheduleQueue();
        this.adHocOperationRunner = operationRunnerFactory.createAdHocRunner();
        this.partitionOperationRunners = this.initPartitionOperationRunners(properties, operationRunnerFactory);
        this.partitionOperationThreads = this.initPartitionThreads(properties);
        this.genericOperationRunners = this.initGenericOperationRunners(properties, operationRunnerFactory);
        this.genericOperationThreads = this.initGenericThreads();
        this.logger.info("Starting with " + this.genericOperationThreads.length + " generic operation threads and " + this.partitionOperationThreads.length + " partition operation threads.");
    }

    private OperationRunner[] initPartitionOperationRunners(GroupProperties properties, OperationRunnerFactory handlerFactory) {
        OperationRunner[] operationRunners = new OperationRunner[properties.getInteger(GroupProperty.PARTITION_COUNT)];
        for (int partitionId = 0; partitionId < operationRunners.length; ++partitionId) {
            operationRunners[partitionId] = handlerFactory.createPartitionRunner(partitionId);
        }
        return operationRunners;
    }

    private OperationRunner[] initGenericOperationRunners(GroupProperties properties, OperationRunnerFactory runnerFactory) {
        int genericThreadCount = properties.getInteger(GroupProperty.GENERIC_OPERATION_THREAD_COUNT);
        if (genericThreadCount <= 0) {
            int coreSize = Runtime.getRuntime().availableProcessors();
            genericThreadCount = Math.max(2, coreSize / 2);
        }
        OperationRunner[] operationRunners = new OperationRunner[genericThreadCount];
        for (int partitionId = 0; partitionId < operationRunners.length; ++partitionId) {
            operationRunners[partitionId] = runnerFactory.createGenericRunner();
        }
        return operationRunners;
    }

    private PartitionOperationThread[] initPartitionThreads(GroupProperties properties) {
        int threadCount = properties.getInteger(GroupProperty.PARTITION_OPERATION_THREAD_COUNT);
        if (threadCount <= 0) {
            int coreSize = Runtime.getRuntime().availableProcessors();
            threadCount = Math.max(2, coreSize);
        }
        PartitionOperationThread[] threads = new PartitionOperationThread[threadCount];
        for (int threadId = 0; threadId < threads.length; ++threadId) {
            PartitionOperationThread operationThread;
            String threadName = this.threadGroup.getThreadPoolNamePrefix("partition-operation") + threadId;
            DefaultScheduleQueue scheduleQueue = new DefaultScheduleQueue();
            threads[threadId] = operationThread = new PartitionOperationThread(threadName, threadId, scheduleQueue, this.logger, this.threadGroup, this.nodeExtension, this.partitionOperationRunners);
            operationThread.start();
            this.metricsRegistry.scanAndRegister(operationThread, "operation." + operationThread.getName());
        }
        for (int partitionId = 0; partitionId < this.partitionOperationRunners.length; ++partitionId) {
            int threadId = partitionId % threadCount;
            PartitionOperationThread thread = threads[threadId];
            OperationRunner runner = this.partitionOperationRunners[partitionId];
            runner.setCurrentThread(thread);
        }
        return threads;
    }

    private GenericOperationThread[] initGenericThreads() {
        int threadCount = this.genericOperationRunners.length;
        GenericOperationThread[] threads = new GenericOperationThread[threadCount];
        for (int threadId = 0; threadId < threads.length; ++threadId) {
            GenericOperationThread operationThread;
            String threadName = this.threadGroup.getThreadPoolNamePrefix("generic-operation") + threadId;
            OperationRunner operationRunner = this.genericOperationRunners[threadId];
            threads[threadId] = operationThread = new GenericOperationThread(threadName, threadId, this.genericScheduleQueue, this.logger, this.threadGroup, this.nodeExtension, operationRunner);
            operationThread.start();
            operationRunner.setCurrentThread(operationThread);
            this.metricsRegistry.scanAndRegister(operationThread, "operation." + operationThread.getName());
        }
        return threads;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public OperationRunner[] getPartitionOperationRunners() {
        return this.partitionOperationRunners;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public OperationRunner[] getGenericOperationRunners() {
        return this.genericOperationRunners;
    }

    @Override
    public boolean isAllowedToRunInCurrentThread(Operation op) {
        Preconditions.checkNotNull(op, "op can't be null");
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof OperationHostileThread) {
            return false;
        }
        int partitionId = op.getPartitionId();
        if (partitionId < 0) {
            return true;
        }
        if (!(currentThread instanceof PartitionOperationThread)) {
            return false;
        }
        PartitionOperationThread partitionThread = (PartitionOperationThread)currentThread;
        return this.toPartitionThreadIndex(partitionId) == partitionThread.threadId;
    }

    @Override
    public boolean isOperationThread() {
        return Thread.currentThread() instanceof OperationThread;
    }

    @Override
    public boolean isInvocationAllowedFromCurrentThread(Operation op, boolean isAsync) {
        Preconditions.checkNotNull(op, "op can't be null");
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof OperationHostileThread) {
            return false;
        }
        if (isAsync) {
            return true;
        }
        if (op.getPartitionId() < 0) {
            return true;
        }
        if (!(currentThread instanceof PartitionOperationThread)) {
            return true;
        }
        PartitionOperationThread partitionThread = (PartitionOperationThread)currentThread;
        OperationRunner runner = partitionThread.getCurrentOperationRunner();
        if (runner != null) {
            return runner.getPartitionId() == op.getPartitionId();
        }
        return this.toPartitionThreadIndex(op.getPartitionId()) == partitionThread.threadId;
    }

    @Override
    public int getRunningOperationCount() {
        int result = 0;
        for (OperationRunner handler : this.partitionOperationRunners) {
            if (handler.currentTask() == null) continue;
            ++result;
        }
        for (OperationRunner handler : this.genericOperationRunners) {
            if (handler.currentTask() == null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getOperationExecutorQueueSize() {
        int size = 0;
        for (PartitionOperationThread t : this.partitionOperationThreads) {
            size += t.scheduleQueue.normalSize();
        }
        return size += this.genericScheduleQueue.normalSize();
    }

    @Override
    public int getPriorityOperationExecutorQueueSize() {
        int size = 0;
        for (PartitionOperationThread t : this.partitionOperationThreads) {
            size += t.scheduleQueue.prioritySize();
        }
        return size += this.genericScheduleQueue.prioritySize();
    }

    @Override
    public int getPartitionOperationThreadCount() {
        return this.partitionOperationThreads.length;
    }

    @Override
    public int getGenericOperationThreadCount() {
        return this.genericOperationThreads.length;
    }

    @Override
    public void execute(Operation op) {
        Preconditions.checkNotNull(op, "op can't be null");
        this.execute(op, op.getPartitionId(), op.isUrgent());
    }

    @Override
    public void execute(PartitionSpecificRunnable task) {
        Preconditions.checkNotNull(task, "task can't be null");
        this.execute(task, task.getPartitionId(), false);
    }

    @Override
    public void runOnCallingThreadIfPossible(Operation op) {
        if (this.isAllowedToRunInCurrentThread(op)) {
            this.runOnCallingThread(op);
        } else {
            this.execute(op);
        }
    }

    @Override
    public void runOnAllPartitionThreads(Runnable task) {
        Preconditions.checkNotNull(task, "task can't be null");
        for (PartitionOperationThread partitionOperationThread : this.partitionOperationThreads) {
            partitionOperationThread.scheduleQueue.addUrgent(task);
        }
    }

    @Override
    public void execute(Packet packet) {
        Preconditions.checkNotNull(packet, "packet can't be null");
        this.checkOpPacket(packet);
        int partitionId = packet.getPartitionId();
        boolean hasPriority = packet.isUrgent();
        this.execute(packet, partitionId, hasPriority);
    }

    private void checkOpPacket(Packet packet) {
        if (!packet.isHeaderSet(0)) {
            throw new IllegalStateException("Packet " + packet + " doesn't have Packet.HEADER_OP set");
        }
    }

    @Override
    public void runOnCallingThread(Operation operation) {
        Preconditions.checkNotNull(operation, "operation can't be null");
        if (!this.isAllowedToRunInCurrentThread(operation)) {
            throw new IllegalThreadStateException("Operation '" + operation + "' cannot be run in current thread: " + Thread.currentThread());
        }
        OperationRunner operationRunner = this.getOperationRunner(operation);
        operationRunner.run(operation);
    }

    OperationRunner getOperationRunner(Operation operation) {
        Preconditions.checkNotNull(operation, "operation can't be null");
        if (operation.getPartitionId() >= 0) {
            return this.partitionOperationRunners[operation.getPartitionId()];
        }
        Thread thread = Thread.currentThread();
        if (!(thread instanceof OperationThread)) {
            return this.adHocOperationRunner;
        }
        OperationThread operationThread = (OperationThread)thread;
        return operationThread.getCurrentOperationRunner();
    }

    private void execute(Object task, int partitionId, boolean priority) {
        ScheduleQueue scheduleQueue;
        if (partitionId < 0) {
            scheduleQueue = this.genericScheduleQueue;
        } else {
            PartitionOperationThread partitionOperationThread = this.partitionOperationThreads[this.toPartitionThreadIndex(partitionId)];
            scheduleQueue = partitionOperationThread.scheduleQueue;
        }
        if (priority) {
            scheduleQueue.addUrgent(task);
        } else {
            scheduleQueue.add(task);
        }
    }

    public int toPartitionThreadIndex(int partitionId) {
        return partitionId % this.partitionOperationThreads.length;
    }

    @Override
    public void shutdown() {
        ClassicOperationExecutor.shutdownAll(this.partitionOperationThreads);
        ClassicOperationExecutor.shutdownAll(this.genericOperationThreads);
        ClassicOperationExecutor.awaitTermination(this.partitionOperationThreads);
        ClassicOperationExecutor.awaitTermination(this.genericOperationThreads);
    }

    private static void shutdownAll(OperationThread[] operationThreads) {
        for (OperationThread thread : operationThreads) {
            thread.shutdown();
        }
    }

    private static void awaitTermination(OperationThread[] operationThreads) {
        for (OperationThread thread : operationThreads) {
            try {
                thread.awaitTermination(3, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "ClassicOperationExecutor{node=" + this.thisAddress + '}';
    }
}

