/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.AddOperation;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class AddRequest
extends RingbufferRequest {
    private Data item;

    public AddRequest() {
    }

    public AddRequest(String name, Data item) {
        super(name);
        this.item = item;
    }

    @Override
    protected Operation prepareOperation() {
        return new AddOperation(this.name, this.item, OverflowPolicy.FAIL);
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.getRawDataOutput().writeData(this.item);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.item = reader.getRawDataInput().readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new RingBufferPermission(this.name, "put");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.item};
    }

    @Override
    public String getMethodName() {
        return "add";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

