/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ReplicatedRecord<K, V>
implements IdentifiedDataSerializable {
    private static final AtomicLongFieldUpdater<ReplicatedRecord> HITS = AtomicLongFieldUpdater.newUpdater(ReplicatedRecord.class, "hits");
    private volatile long hits;
    private volatile long lastAccessTime = Clock.currentTimeMillis();
    private K key;
    private V value;
    private long ttlMillis;
    private volatile long updateTime = Clock.currentTimeMillis();
    private volatile long creationTime = Clock.currentTimeMillis();
    private int partitionId;

    public ReplicatedRecord() {
    }

    public ReplicatedRecord(K key, V value, long ttlMillis, int partitionId) {
        this.key = key;
        this.value = value;
        this.ttlMillis = ttlMillis;
        this.partitionId = partitionId;
    }

    public K getKey() {
        this.access();
        return this.getKeyInternal();
    }

    public K getKeyInternal() {
        return this.key;
    }

    public V getValue() {
        this.access();
        return this.getValueInternal();
    }

    public V getValueInternal() {
        return this.value;
    }

    public boolean isTombstone() {
        return this.value == null;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public V setValue(V value, long ttlMillis) {
        this.access();
        return this.setValueInternal(value, ttlMillis);
    }

    public V setValueInternal(V value, long ttlMillis) {
        V oldValue = this.value;
        this.value = value;
        this.updateTime = Clock.currentTimeMillis();
        this.ttlMillis = ttlMillis;
        return oldValue;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        this.hits = hits;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    private void access() {
        HITS.incrementAndGet(this);
        this.lastAccessTime = Clock.currentTimeMillis();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.value);
        out.writeLong(this.ttlMillis);
        out.writeLong(this.updateTime);
        out.writeLong(this.creationTime);
        out.writeLong(this.hits);
        out.writeInt(this.partitionId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readObject();
        this.value = in.readObject();
        this.ttlMillis = in.readLong();
        this.updateTime = in.readLong();
        this.creationTime = in.readLong();
        HITS.set(this, in.readLong());
        this.partitionId = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedRecord that = (ReplicatedRecord)o;
        if (this.ttlMillis != that.ttlMillis) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.ttlMillis ^ this.ttlMillis >>> 32);
        return result;
    }

    public String toString() {
        return "ReplicatedRecord{key=" + this.key + ", value=" + this.value + ", ttlMillis=" + this.ttlMillis + ", hits=" + HITS.get(this) + ", creationTime=" + this.creationTime + ", lastAccessTime=" + this.lastAccessTime + ", updateTime=" + this.updateTime + '}';
    }
}

