/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.InternalReplicatedMapStorage;
import com.hazelcast.replicatedmap.impl.record.RecordMigrationInfo;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class SyncReplicatedMapDataOperation<K, V>
extends AbstractOperation {
    private static ILogger logger = Logger.getLogger(SyncReplicatedMapDataOperation.class.getName());
    private String name;
    private Set<RecordMigrationInfo> recordSet;
    private long version;

    public SyncReplicatedMapDataOperation() {
    }

    public SyncReplicatedMapDataOperation(String name, Set<RecordMigrationInfo> recordSet, long version) {
        this.name = name;
        this.recordSet = recordSet;
        this.version = version;
    }

    @Override
    public void run() throws Exception {
        logger.finest("Carrying " + this.recordSet.size() + " records for partition -> " + this.getPartitionId() + " from -> " + this.getCallerAddress() + ", to -> " + this.getNodeEngine().getThisAddress());
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        AbstractReplicatedRecordStore store = (AbstractReplicatedRecordStore)service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        InternalReplicatedMapStorage<Object, Object> newStorage = new InternalReplicatedMapStorage<Object, Object>();
        for (RecordMigrationInfo record : this.recordSet) {
            Object key = store.marshall(record.getKey());
            Object value = store.marshall(record.getValue());
            ReplicatedRecord<Object, Object> replicatedRecord = this.buildReplicatedRecord(key, value, record.getTtl());
            ReplicatedRecord oldRecord = store.getReplicatedRecord(key);
            if (oldRecord != null) {
                replicatedRecord.setHits(oldRecord.getHits());
            }
            newStorage.putInternal(key, replicatedRecord);
        }
        newStorage.setVersion(this.version);
        AtomicReference storageRef = store.getStorageRef();
        storageRef.set(newStorage);
        store.setLoaded(true);
    }

    private ReplicatedRecord<K, V> buildReplicatedRecord(K key, V value, long ttlMillis) {
        int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(key);
        return new ReplicatedRecord<K, V>(key, value, ttlMillis, partitionId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.version);
        out.writeInt(this.recordSet.size());
        for (RecordMigrationInfo record : this.recordSet) {
            record.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.version = in.readLong();
        int size = in.readInt();
        this.recordSet = new HashSet<RecordMigrationInfo>(size);
        for (int j = 0; j < size; ++j) {
            RecordMigrationInfo record = new RecordMigrationInfo();
            record.readData(in);
            this.recordSet.add(record);
        }
    }
}

