/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class ClearLocalOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private String mapName;
    private transient int response;

    public ClearLocalOperation() {
    }

    public ClearLocalOperation(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public void run() throws Exception {
        if (this.getNodeEngine().getConfig().isLiteMember()) {
            return;
        }
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        this.response = service.clearLocalRecordStores(this.mapName);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
    }
}

