/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.predicates.AbstractPredicate;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPredicate
extends AbstractPredicate {
    private String regex;
    private volatile Pattern pattern;

    public RegexPredicate() {
    }

    public RegexPredicate(String attributeName, String regex) {
        this.attributeName = attributeName;
        this.regex = regex;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry mapEntry, Comparable attributeValue) {
        String stringAttributeValue = (String)((Object)attributeValue);
        if (stringAttributeValue == null) {
            return this.regex == null;
        }
        if (this.regex == null) {
            return false;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        Matcher m = this.pattern.matcher(stringAttributeValue);
        return m.matches();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributeName);
        out.writeUTF(this.regex);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readUTF();
        this.regex = in.readUTF();
    }

    public String toString() {
        return this.attributeName + " REGEX '" + this.regex + "'";
    }
}

