/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.query.extractor.MultiResult;
import com.hazelcast.query.impl.getters.FieldGetter;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.MethodGetter;
import com.hazelcast.query.impl.getters.NullGetter;
import com.hazelcast.query.impl.getters.ThisGetter;
import com.hazelcast.util.CollectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;

public final class GetterFactory {
    private GetterFactory() {
    }

    public static Getter newFieldGetter(Object object, Getter parentGetter, Field field, String modifierSuffix) throws Exception {
        Class<?> fieldType = field.getType();
        Class<?> returnType = null;
        if (GetterFactory.isExtractingFromCollection(fieldType, modifierSuffix)) {
            Object currentObject = GetterFactory.getCurrentObject(object, parentGetter);
            if (currentObject == null) {
                return NullGetter.NULL_GETTER;
            }
            Collection collection = (Collection)field.get(currentObject);
            returnType = GetterFactory.getCollectionType(collection);
            if (returnType == null) {
                return NullGetter.NULL_GETTER;
            }
        }
        return new FieldGetter(parentGetter, field, modifierSuffix, returnType);
    }

    public static Getter newMethodGetter(Object object, Getter parentGetter, Method method, String modifierSuffix) throws Exception {
        Class<?> methodReturnType = method.getReturnType();
        Class<?> returnType = null;
        if (GetterFactory.isExtractingFromCollection(methodReturnType, modifierSuffix)) {
            Object currentObject = GetterFactory.getCurrentObject(object, parentGetter);
            if (currentObject == null) {
                return NullGetter.NULL_GETTER;
            }
            Collection collection = (Collection)method.invoke(currentObject, new Object[0]);
            returnType = GetterFactory.getCollectionType(collection);
            if (returnType == null) {
                return NullGetter.NULL_GETTER;
            }
        }
        return new MethodGetter(parentGetter, method, modifierSuffix, returnType);
    }

    public static Getter newThisGetter(Getter parent, Object object) {
        return new ThisGetter(parent, object);
    }

    private static Class<?> getCollectionType(Collection collection) throws Exception {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Object targetObject = CollectionUtil.getItemAtPositionOrNull(collection, 0);
        if (targetObject == null) {
            return null;
        }
        return targetObject.getClass();
    }

    private static Object unwrapMultiResult(Object currentObject) {
        if (currentObject instanceof MultiResult) {
            currentObject = GetterFactory.getFirstObjectFromMultiResult(currentObject);
        }
        return currentObject;
    }

    private static Object getFirstObjectFromMultiResult(Object currentObject) {
        MultiResult multiResult = (MultiResult)currentObject;
        if (multiResult.isEmpty()) {
            return null;
        }
        currentObject = multiResult.getResults().iterator().next();
        if (currentObject == null) {
            return null;
        }
        return currentObject;
    }

    private static boolean isExtractingFromCollection(Class<?> type, String modifierSuffix) {
        return modifierSuffix != null && Collection.class.isAssignableFrom(type);
    }

    private static Object getCurrentObject(Object obj, Getter parent) throws Exception {
        Object currentObject = parent == null ? obj : parent.getValue(obj);
        return GetterFactory.unwrapMultiResult(currentObject);
    }
}

