/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.query.extractor.ValueExtractor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Extractors {
    private static final Extractors EMPTY = new Extractors(Collections.<MapAttributeConfig>emptyList());
    private final Map<String, ValueExtractor> extractors = new HashMap<String, ValueExtractor>();

    public Extractors(List<MapAttributeConfig> mapAttributeConfigs) {
        for (MapAttributeConfig config : mapAttributeConfigs) {
            if (this.extractors.containsKey(config.getName())) {
                throw new IllegalArgumentException("Could not add " + config + ". Extractor for this attribute name already added.");
            }
            this.extractors.put(config.getName(), this.instantiateExtractor(config));
        }
    }

    private ValueExtractor instantiateExtractor(MapAttributeConfig config) {
        try {
            Class<?> clazz = Class.forName(config.getExtractor());
            Object extractor = clazz.newInstance();
            if (extractor instanceof ValueExtractor) {
                return (ValueExtractor)extractor;
            }
            throw new IllegalArgumentException("Extractor does not extend ValueExtractor class " + config);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not initialize extractor " + config, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Could not initialize extractor " + config, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not initialize extractor " + config, ex);
        }
    }

    public ValueExtractor getExtractor(String attribute) {
        return this.extractors.get(attribute);
    }

    public static Extractors empty() {
        return EMPTY;
    }
}

