/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.impl.Extractors;
import com.hazelcast.query.impl.QueryableEntry;

public class CachedQueryEntry
extends QueryableEntry {
    private Data keyData;
    private Object keyObject;
    private Data valueData;
    private Object valueObject;

    public CachedQueryEntry() {
    }

    public CachedQueryEntry(SerializationService serializationService, Data key, Object value, Extractors extractors) {
        this.init(serializationService, key, value, extractors);
    }

    public void init(SerializationService serializationService, Data key, Object value, Extractors extractors) {
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        this.serializationService = serializationService;
        this.keyData = key;
        this.keyObject = null;
        if (value instanceof Data) {
            this.valueData = (Data)value;
            this.valueObject = null;
        } else {
            this.valueObject = value;
            this.valueData = null;
        }
        this.extractors = extractors;
    }

    @Override
    public Object getKey() {
        if (this.keyObject == null) {
            this.keyObject = this.serializationService.toObject(this.keyData);
        }
        return this.keyObject;
    }

    @Override
    public Object getValue() {
        if (this.valueObject == null) {
            this.valueObject = this.serializationService.toObject(this.valueData);
        }
        return this.valueObject;
    }

    @Override
    public Data getKeyData() {
        if (this.keyData == null) {
            this.keyData = this.serializationService.toData(this.keyObject);
        }
        return this.keyData;
    }

    @Override
    public Data getValueData() {
        if (this.valueData == null) {
            this.valueData = this.serializationService.toData(this.valueObject);
        }
        return this.valueData;
    }

    @Override
    protected Object getTargetObject(boolean key) {
        Object targetObject = key ? (this.keyObject == null ? (this.keyData.isPortable() ? this.keyData : this.getKey()) : (this.keyObject instanceof Portable ? this.getKeyData() : this.getKey())) : (this.valueObject == null ? (this.valueData.isPortable() ? this.valueData : this.getValue()) : (this.valueObject instanceof Portable ? this.getValueData() : this.getValue()));
        return targetObject;
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedQueryEntry that = (CachedQueryEntry)o;
        return this.keyData.equals(that.keyData);
    }

    @Override
    public int hashCode() {
        return this.keyData.hashCode();
    }
}

