/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.osgi.impl;

import com.hazelcast.internal.management.ScriptEngineManagerContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.osgi.impl.OSGiScriptEngineManager;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.osgi.framework.BundleContext;

final class ScriptEngineActivator {
    private static final ILogger LOGGER = Logger.getLogger(ScriptEngineActivator.class);

    private ScriptEngineActivator() {
    }

    public static void registerOsgiScriptEngineManager(BundleContext context) {
        OSGiScriptEngineManager scriptEngineManager = new OSGiScriptEngineManager(context);
        ScriptEngineManagerContext.setScriptEngineManager(scriptEngineManager);
        if (LOGGER.isFinestEnabled()) {
            StringBuilder msg = new StringBuilder("Available script engines are:");
            for (ScriptEngineFactory scriptEngineFactory : ((ScriptEngineManager)scriptEngineManager).getEngineFactories()) {
                msg.append(scriptEngineFactory.getEngineName()).append('\n');
            }
            LOGGER.finest(msg.toString());
        }
    }
}

