/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.aggregation.impl;

import com.hazelcast.mapreduce.Context;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.mapreduce.aggregation.impl.AggregationsDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
class SupplierConsumingMapper<Key, ValueIn, ValueOut>
implements Mapper<Key, ValueIn, Key, ValueOut>,
IdentifiedDataSerializable {
    private transient SimpleEntry<Key, ValueIn> entry = new SimpleEntry();
    private Supplier<Key, ValueIn, ValueOut> supplier;

    SupplierConsumingMapper() {
    }

    SupplierConsumingMapper(Supplier<Key, ValueIn, ValueOut> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void map(Key key, ValueIn value, Context<Key, ValueOut> context) {
        ((SimpleEntry)this.entry).key = key;
        ((SimpleEntry)this.entry).value = value;
        ValueOut valueOut = this.supplier.apply(this.entry);
        if (valueOut != null) {
            context.emit(key, valueOut);
        }
    }

    @Override
    public int getFactoryId() {
        return AggregationsDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.supplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.supplier = (Supplier)in.readObject();
    }

    private static final class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        private SimpleEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

