/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.BasicRecordStoreLoader;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreLoader;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.Collection;

abstract class AbstractRecordStore
implements RecordStore<Record> {
    protected final Storage<Data, Record> storage;
    protected final RecordFactory recordFactory;
    protected final String name;
    protected final MapContainer mapContainer;
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;
    protected final int partitionId;
    protected final InMemoryFormat inMemoryFormat;

    protected AbstractRecordStore(MapContainer mapContainer, int partitionId) {
        this.mapContainer = mapContainer;
        this.partitionId = partitionId;
        this.mapServiceContext = mapContainer.getMapServiceContext();
        this.serializationService = this.mapServiceContext.getNodeEngine().getSerializationService();
        this.name = mapContainer.getName();
        this.recordFactory = mapContainer.getRecordFactoryConstructor().createNew(null);
        this.inMemoryFormat = mapContainer.getMapConfig().getInMemoryFormat();
        this.storage = this.createStorage(this.recordFactory, this.inMemoryFormat);
    }

    @Override
    public Record createRecord(Object value, long ttlMillis, long now) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        Record record = this.recordFactory.newRecord(value);
        record.setLastAccessTime(now);
        record.setLastUpdateTime(now);
        record.setCreationTime(now);
        long ttlMillisFromConfig = ExpirationTimeSetter.calculateTTLMillis(mapConfig);
        long ttl = ExpirationTimeSetter.pickTTL(ttlMillis, ttlMillisFromConfig);
        record.setTtl(ttl);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(mapConfig);
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
        return record;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        return new StorageImpl(recordFactory, memoryFormat);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public long getHeapCost() {
        return this.storage.getSizeEstimator().getSize();
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected void accessRecord(Record record, long now) {
        record.setLastAccessTime(now);
        record.onAccess();
    }

    protected void accessRecord(Record record) {
        long now = this.getNow();
        this.accessRecord(record, now);
    }

    protected void updateRecord(Data key, Record record, Object value, long now) {
        this.accessRecord(record, now);
        record.setLastUpdateTime(now);
        record.onUpdate();
        this.storage.updateRecordValue(key, record, value);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    protected void saveIndex(Record record, Object oldValue) {
        Data dataKey = record.getKey();
        Indexes indexes = this.mapContainer.getIndexes();
        if (indexes.hasIndex()) {
            Object value = Records.getValueOrCachedValue(record, this.serializationService);
            if (InMemoryFormat.NATIVE.equals((Object)this.inMemoryFormat)) {
                dataKey = this.toData(dataKey);
                value = this.toData(record.getValue());
                oldValue = this.toData(oldValue);
            }
            QueryableEntry queryableEntry = this.mapContainer.newQueryEntry(dataKey, value);
            indexes.saveEntryIndex(queryableEntry, oldValue);
        }
    }

    protected void removeIndex(Record record) {
        Indexes indexes = this.mapContainer.getIndexes();
        if (indexes.hasIndex()) {
            Data key = record.getKey();
            Object value = Records.getValueOrCachedValue(record, this.serializationService);
            if (InMemoryFormat.NATIVE.equals((Object)this.inMemoryFormat)) {
                key = this.toData(key);
                value = this.toData(value);
            }
            indexes.removeEntryIndex(key, value);
        }
    }

    protected void removeIndex(Collection<Record> records) {
        Indexes indexes = this.mapContainer.getIndexes();
        if (!indexes.hasIndex()) {
            return;
        }
        for (Record record : records) {
            this.removeIndex(record);
        }
    }

    protected LockStore createLockStore() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService == null) {
            return null;
        }
        return lockService.createLockStore(this.partitionId, new DefaultObjectNamespace("hz:impl:mapService", this.name));
    }

    protected RecordStoreLoader createRecordStoreLoader(MapStoreContext mapStoreContext) {
        return mapStoreContext.getMapStoreWrapper() == null ? RecordStoreLoader.EMPTY_LOADER : new BasicRecordStoreLoader(this);
    }

    protected Data toData(Object value) {
        return this.mapServiceContext.toData(value);
    }

    public void setSizeEstimator(SizeEstimator sizeEstimator) {
        this.storage.setSizeEstimator(sizeEstimator);
    }

    @Override
    public void dispose() {
        this.storage.dispose();
    }

    @Override
    public Storage<Data, Record> getStorage() {
        return this.storage;
    }
}

