/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.AbstractRecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    private static final int POST_READ_CHECK_POINT = 63;
    private Iterator<Record> expirationIterator;
    private int readCountBeforeCleanUp;
    private long lruAccessSequenceNumber;
    private long lastEvictionTime;
    private volatile boolean hasEntryWithCustomTTL;
    private final long expiryDelayMillis;
    private final Evictor evictor;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        GroupProperties groupProperties = nodeEngine.getGroupProperties();
        this.expiryDelayMillis = groupProperties.getMillis(GroupProperty.MAP_EXPIRY_DELAY_SECONDS);
        this.evictor = mapContainer.getEvictor();
    }

    @Override
    public boolean isEvictionEnabled() {
        EvictionPolicy evictionPolicy = this.getEvictionPolicy();
        return !EvictionPolicy.NONE.equals((Object)evictionPolicy);
    }

    private EvictionPolicy getEvictionPolicy() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return mapConfig.getEvictionPolicy();
    }

    private boolean isRecordStoreExpirable() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return this.hasEntryWithCustomTTL || mapConfig.getMaxIdleSeconds() > 0 || mapConfig.getTimeToLiveSeconds() > 0;
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean backup) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evictedEntryCount = 0;
        while ((evictedEntryCount += this.evictExpiredEntriesInternal(maxIterationCount, now, backup)) < maxIterationCount && ++loop <= 3) {
        }
    }

    @Override
    public boolean isExpirable() {
        return this.isRecordStoreExpirable();
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntriesInternal(int maxIterationCount, long now, boolean backup) {
        int evictedCount = 0;
        int checkedEntryCount = 0;
        this.initExpirationIterator();
        while (this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount) {
            ++checkedEntryCount;
            Record record = this.expirationIterator.next();
            if ((record = this.getOrNullIfExpired(record, now, backup)) != null) continue;
            ++evictedCount;
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.storage.values().iterator();
        }
    }

    protected void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    @Override
    public void evictEntries(long now) {
        if (this.isEvictionEnabled()) {
            this.cleanUp(now);
        }
    }

    protected void postReadCleanUp(long now) {
        if (this.isEvictionEnabled()) {
            ++this.readCountBeforeCleanUp;
            if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
                this.cleanUp(now);
            }
        }
    }

    private void cleanUp(long now) {
        if (this.size() == 0) {
            return;
        }
        if (this.shouldEvict(now)) {
            this.evict();
            this.lastEvictionTime = now;
            this.readCountBeforeCleanUp = 0;
        }
    }

    protected boolean shouldEvict(long now) {
        return this.isEvictionEnabled() && this.inEvictableTimeWindow(now) && this.checkEvictionPossible();
    }

    private void evict() {
        int removalSize = this.getRemovalSize();
        if (removalSize < 1) {
            return;
        }
        this.evictor.removeSize(removalSize, this);
    }

    private int getRemovalSize() {
        int size = this.size();
        if (size < 1) {
            return 0;
        }
        int removalSize = this.evictor.findRemovalSize(this);
        if (removalSize < 1) {
            return 0;
        }
        return removalSize;
    }

    private Evictor getEvictor() {
        return this.mapContainer.getEvictor();
    }

    private boolean inEvictableTimeWindow(long now) {
        long minEvictionCheckMillis = this.getMinEvictionCheckMillis();
        return minEvictionCheckMillis == 0L || now - this.lastEvictionTime > minEvictionCheckMillis;
    }

    private long getMinEvictionCheckMillis() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return mapConfig.getMinEvictionCheckMillis();
    }

    private boolean checkEvictionPossible() {
        Evictor evictor = this.getEvictor();
        EvictionChecker evictionChecker = evictor.getEvictionChecker();
        return evictionChecker.checkEvictionPossible(this);
    }

    protected void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L && ttl < Long.MAX_VALUE) {
            this.hasEntryWithCustomTTL = true;
        }
    }

    abstract Object evictInternal(Data var1, boolean var2);

    abstract Object evictInternal(Data var1, Record var2, boolean var3);

    protected Record getOrNullIfExpired(Record record, long now, boolean backup) {
        if (!this.isRecordStoreExpirable()) {
            return record;
        }
        if (record == null) {
            return null;
        }
        Data key = record.getKey();
        if (this.isLocked(key)) {
            return record;
        }
        if (!this.isExpired(record, now, backup)) {
            return record;
        }
        Object value = record.getValue();
        this.evictInternal(key, backup);
        if (!backup) {
            this.doPostEvictionOperations(key, value, true);
        }
        return null;
    }

    @Override
    public boolean isExpired(Record record, long now, boolean backup) {
        return record == null || this.isIdleExpired(record, now, backup) == null || this.isTTLExpired(record, now, backup) == null;
    }

    private Record isIdleExpired(Record record, long now, boolean backup) {
        long maxIdleMillis;
        long idleMillis;
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        long elapsedMillis = now - lastAccessTime;
        return elapsedMillis >= (idleMillis = ExpirationTimeSetter.calculateExpirationWithDelay(maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig()), this.expiryDelayMillis, backup)) ? null : record;
    }

    private Record isTTLExpired(Record record, long now, boolean backup) {
        long ttlMillis;
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long lastUpdateTime = record.getLastUpdateTime();
        long elapsedMillis = now - lastUpdateTime;
        return elapsedMillis >= (ttlMillis = ExpirationTimeSetter.calculateExpirationWithDelay(ttl, this.expiryDelayMillis, backup)) ? null : record;
    }

    @Override
    public void doPostEvictionOperations(Data key, Object value, boolean isExpired) {
        MapEventPublisher mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EventService eventService = nodeEngine.getEventService();
        if (!eventService.hasEventRegistration("hz:impl:mapService", this.name)) {
            return;
        }
        Address thisAddress = nodeEngine.getThisAddress();
        Data dataValue = this.mapServiceContext.toData(value);
        mapEventPublisher.publishEvent(thisAddress, this.name, EntryEventType.EVICTED, true, key, dataValue, null);
        if (isExpired) {
            mapEventPublisher.publishEvent(thisAddress, this.name, EntryEventType.EXPIRED, true, key, dataValue, null);
        }
    }

    void increaseRecordEvictionCriteriaNumber(Record record, EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case LFU: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
    }

    @Override
    protected void accessRecord(Record record, long now) {
        super.accessRecord(record, now);
        this.increaseRecordEvictionCriteriaNumber(record, this.getEvictionPolicy());
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig());
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
    }

    protected void mergeRecordExpiration(Record record, EntryView mergingEntry) {
        long ttlMillis = mergingEntry.getTtl();
        record.setTtl(ttlMillis);
        long lastAccessTime = mergingEntry.getLastAccessTime();
        record.setLastAccessTime(lastAccessTime);
        long lastUpdateTime = mergingEntry.getLastUpdateTime();
        record.setLastUpdateTime(lastUpdateTime);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig());
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
        this.markRecordStoreExpirable(record.getTtl());
    }

    protected void deleteRecord(Record record) {
        this.storage.removeRecord(record);
    }

    protected final class ReadOnlyRecordIterator
    implements Iterator<Record> {
        private final long now;
        private final boolean checkExpiration;
        private final boolean backup;
        private final Iterator<Record> iterator;
        private Record nextRecord;
        private Record lastReturned;

        protected ReadOnlyRecordIterator(Collection<Record> values, long now, boolean backup) {
            this(values, now, true, backup);
        }

        protected ReadOnlyRecordIterator(Collection<Record> values) {
            this(values, -1L, false, false);
        }

        private ReadOnlyRecordIterator(Collection<Record> values, long now, boolean checkExpiration, boolean backup) {
            this.iterator = values.iterator();
            this.now = now;
            this.checkExpiration = checkExpiration;
            this.backup = backup;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Record next() {
            if (this.nextRecord == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextRecord;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by this iterator");
        }

        private void advance() {
            long now = this.now;
            boolean checkExpiration = this.checkExpiration;
            Iterator<Record> iterator = this.iterator;
            while (iterator.hasNext()) {
                this.nextRecord = iterator.next();
                if (this.nextRecord == null) continue;
                if (!checkExpiration) {
                    return;
                }
                if (AbstractEvictableRecordStore.this.isExpired(this.nextRecord, now, this.backup)) continue;
                return;
            }
            this.nextRecord = null;
        }
    }
}

