/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.CachedDataRecord;
import com.hazelcast.map.impl.record.CachedDataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.nio.serialization.Data;

public final class Records {
    private Records() {
    }

    public static void applyRecordInfo(Record record, RecordInfo replicationInfo) {
        record.setStatistics(replicationInfo.getStatistics());
        record.setVersion(replicationInfo.getVersion());
        record.setEvictionCriteriaNumber(replicationInfo.getEvictionCriteriaNumber());
        record.setTtl(replicationInfo.getTtl());
        record.setLastAccessTime(replicationInfo.getLastAccessTime());
        record.setLastUpdateTime(replicationInfo.getLastUpdateTime());
    }

    public static RecordInfo buildRecordInfo(Record record) {
        RecordInfo info = new RecordInfo();
        info.setStatistics(record.getStatistics());
        info.setVersion(record.getVersion());
        info.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber());
        info.setLastAccessTime(record.getLastAccessTime());
        info.setLastUpdateTime(record.getLastUpdateTime());
        info.setTtl(record.getTtl());
        return info;
    }

    public static Object getValueOrCachedValue(Record record, SerializationService serializationService) {
        Object value = record.getCachedValue();
        if (value == Record.NOT_CACHED) {
            value = record.getValue();
        } else if (value == null && Records.shouldCache(record, value = record.getValue())) {
            value = serializationService.toObject(value);
            record.setCachedValue(value);
        }
        return value;
    }

    private static boolean shouldCache(Record record, Object value) {
        boolean isCachableRecordType;
        boolean bl = isCachableRecordType = record instanceof CachedDataRecordWithStats || record instanceof CachedDataRecord;
        if (!isCachableRecordType) {
            return false;
        }
        return value instanceof Data && !((Data)value).isPortable();
    }
}

