/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.query.QueryResultIterator;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.IterationType;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public class QueryResultSet
extends AbstractSet
implements IdentifiedDataSerializable {
    private Set<QueryResultRow> rows = Collections.newSetFromMap(new ConcurrentHashMap());
    private final SerializationService serializationService;
    private IterationType iterationType;
    private boolean binary;

    public QueryResultSet() {
        this.serializationService = null;
    }

    public QueryResultSet(SerializationService serializationService, IterationType iterationType, boolean binary) {
        this.serializationService = serializationService;
        this.iterationType = iterationType;
        this.binary = binary;
    }

    public Iterator<Map.Entry> rawIterator() {
        return new QueryResultIterator(this.rows.iterator(), IterationType.ENTRY, this.binary, this.serializationService);
    }

    @Override
    public boolean add(QueryResultRow row) {
        return this.rows.add(row);
    }

    public boolean remove(QueryResultRow row) {
        return this.rows.remove(row);
    }

    public boolean contains(QueryResultRow row) {
        return this.rows.contains(row);
    }

    @Override
    public boolean add(Object row) {
        return this.rows.add((QueryResultRow)row);
    }

    @Override
    public Iterator iterator() {
        return new QueryResultIterator(this.rows.iterator(), this.iterationType, this.binary, this.serializationService);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.binary);
        out.writeByte(this.iterationType.getId());
        out.writeInt(this.rows.size());
        for (QueryResultRow entry : this.rows) {
            switch (this.iterationType) {
                case KEY: {
                    out.writeData(entry.getKey());
                    break;
                }
                case VALUE: {
                    out.writeData(entry.getValue());
                    break;
                }
                case ENTRY: {
                    out.writeData(entry.getKey());
                    out.writeData(entry.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized iterationType:" + (Object)((Object)this.iterationType));
                }
            }
            out.writeObject(entry);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.binary = in.readBoolean();
        this.iterationType = IterationType.getById(in.readByte());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.rows.add((QueryResultRow)in.readObject());
        }
    }

    @Override
    public String toString() {
        return "QueryResultSet{rows=" + this.entries() + ", iterationType=" + (Object)((Object)this.iterationType) + ", data=" + this.binary + '}';
    }

    private String entries() {
        Iterator i = this.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = i.next()) == this ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }
}

