/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NearCachedMapProxyImpl<K, V>
extends MapProxyImpl<K, V> {
    protected NearCache nearCache;
    protected boolean cacheLocalEntries;

    public NearCachedMapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine) {
        super(name, mapService, nodeEngine);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.init();
    }

    protected void init() {
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        this.nearCache = nearCacheProvider.getOrCreateNearCache(this.name);
        this.cacheLocalEntries = this.getMapConfig().getNearCacheConfig().isCacheLocalEntries();
    }

    @Override
    protected Object getInternal(Data key) {
        Object value = this.getCachedValue(key);
        if (value != null) {
            if (this.isCachedNull(value)) {
                return null;
            }
            return value;
        }
        value = super.getInternal(key);
        if (!this.isOwn(key) || this.cacheLocalEntries) {
            this.nearCache.put(key, this.toData(value));
        }
        return value;
    }

    @Override
    protected ICompletableFuture<Data> getAsyncInternal(final Data key) {
        Object value = this.nearCache.get(key);
        if (value != null) {
            if (this.isCachedNull(value)) {
                value = null;
            }
            return new CompletedFuture<Data>(this.getNodeEngine().getSerializationService(), value, this.getNodeEngine().getExecutionService().getExecutor("hz:async"));
        }
        ICompletableFuture<Data> future = super.getAsyncInternal(key);
        future.andThen(new ExecutionCallback<Data>(){

            @Override
            public void onResponse(Data response) {
                if (!NearCachedMapProxyImpl.this.isOwn(key) || NearCachedMapProxyImpl.this.cacheLocalEntries) {
                    NearCachedMapProxyImpl.this.nearCache.put(key, response);
                }
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    protected boolean isCachedNull(Object value) {
        return NearCache.NULL_OBJECT.equals(value);
    }

    @Override
    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        this.invalidateCache(key);
        return super.putInternal(key, value, ttl, timeunit);
    }

    @Override
    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        this.invalidateCache(key);
        return super.tryPutInternal(key, value, timeout, timeunit);
    }

    @Override
    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        this.invalidateCache(key);
        return super.putIfAbsentInternal(key, value, ttl, timeunit);
    }

    @Override
    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        super.putTransientInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
    }

    @Override
    protected ICompletableFuture<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        this.invalidateCache(key);
        return super.putAsyncInternal(key, value, ttl, timeunit);
    }

    @Override
    protected boolean replaceInternal(Data key, Data expect, Data update) {
        this.invalidateCache(key);
        return super.replaceInternal(key, expect, update);
    }

    @Override
    protected Data replaceInternal(Data key, Data value) {
        this.invalidateCache(key);
        return super.replaceInternal(key, value);
    }

    @Override
    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        this.invalidateCache(key);
        super.setInternal(key, value, ttl, timeunit);
    }

    @Override
    protected boolean evictInternal(Data key) {
        this.invalidateCache(key);
        return super.evictInternal(key);
    }

    @Override
    protected void evictAllInternal() {
        this.nearCache.clear();
        super.evictAllInternal();
    }

    @Override
    public void loadAllInternal(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
        super.loadAllInternal(replaceExistingValues);
    }

    @Override
    protected void loadInternal(Iterable keys, boolean replaceExistingValues) {
        this.invalidateCache(keys);
        super.loadInternal(keys, replaceExistingValues);
    }

    @Override
    protected Data removeInternal(Data key) {
        this.invalidateCache(key);
        return super.removeInternal(key);
    }

    @Override
    protected void deleteInternal(Data key) {
        this.invalidateCache(key);
        super.deleteInternal(key);
    }

    @Override
    protected boolean removeInternal(Data key, Data value) {
        this.invalidateCache(key);
        return super.removeInternal(key, value);
    }

    @Override
    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        this.invalidateCache(key);
        return super.tryRemoveInternal(key, timeout, timeunit);
    }

    @Override
    protected ICompletableFuture<Data> removeAsyncInternal(Data key) {
        this.invalidateCache(key);
        return super.removeAsyncInternal(key);
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get(keyData);
        if (cached != null) {
            return !this.isCachedNull(cached);
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected void getAllObjectInternal(List<Data> keys, List resultingKeyValuePairs) {
        this.getCachedValue(keys, resultingKeyValuePairs);
        int currentSize = resultingKeyValuePairs.size();
        super.getAllObjectInternal(keys, resultingKeyValuePairs);
        int i = currentSize;
        while (i < resultingKeyValuePairs.size()) {
            Data key = this.toData(resultingKeyValuePairs.get(i++));
            Data value = this.toData(resultingKeyValuePairs.get(i++));
            if (this.isOwn(key) && !this.cacheLocalEntries) continue;
            this.nearCache.put(key, value);
        }
    }

    @Override
    protected Future createPutAllOperationFuture(String name, MapEntries mapEntries, int partitionId) {
        Collection<Map.Entry<Data, Data>> collection = mapEntries.entries();
        for (Map.Entry<Data, Data> entry : collection) {
            this.invalidateCache(entry.getKey());
        }
        return super.createPutAllOperationFuture(name, mapEntries, partitionId);
    }

    @Override
    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        this.invalidateCache(key);
        return super.executeOnKeyInternal(key, entryProcessor);
    }

    @Override
    public Map executeOnKeysInternal(Set<Data> keys, EntryProcessor entryProcessor) {
        this.invalidateCache((Collection<Data>)keys);
        return super.executeOnKeysInternal((Set)keys, entryProcessor);
    }

    @Override
    public ICompletableFuture executeOnKeyInternal(Data key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        this.invalidateCache(key);
        return super.executeOnKeyInternal(key, entryProcessor, callback);
    }

    @Override
    public void executeOnEntriesInternal(EntryProcessor entryProcessor, Predicate predicate, List<Data> resultingKeyValuePairs) {
        super.executeOnEntriesInternal(entryProcessor, predicate, (List)resultingKeyValuePairs);
        for (int i = 0; i < resultingKeyValuePairs.size(); i += 2) {
            Data key = resultingKeyValuePairs.get(i);
            this.invalidateCache(key);
        }
    }

    protected Object getCachedValue(Data key) {
        Object cached = this.nearCache.get(key);
        if (cached == null) {
            return null;
        }
        this.mapServiceContext.interceptAfterGet(this.name, cached);
        return cached;
    }

    protected void getCachedValue(List<Data> keys, List<Object> resultingKeyValuePairs) {
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Object value = this.getCachedValue(key);
            if (value == null) continue;
            if (!this.isCachedNull(value)) {
                resultingKeyValuePairs.add(this.toObject(key));
                resultingKeyValuePairs.add(this.toObject(value));
            }
            iterator.remove();
        }
    }

    protected void invalidateCache(Data key) {
        if (key != null) {
            this.nearCache.remove(key);
        }
    }

    protected void invalidateCache(Collection<Data> keys) {
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    protected void invalidateCache(Iterable<Data> keys) {
        NearCache nearCache = this.nearCache;
        for (Data key : keys) {
            nearCache.remove(key);
        }
    }

    protected boolean isOwn(Data key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionService.getPartitionOwner(partitionId).equals(this.thisAddress);
    }
}

