/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutFromLoadAllBackupOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PutFromLoadAllOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation,
BackupAwareOperation {
    private List<Data> keyValueSequence;

    public PutFromLoadAllOperation() {
        this.keyValueSequence = Collections.emptyList();
    }

    public PutFromLoadAllOperation(String name, List<Data> keyValueSequence) {
        super(name);
        this.keyValueSequence = keyValueSequence;
    }

    @Override
    public void run() throws Exception {
        List<Data> keyValueSequence = this.keyValueSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        int partitionId = this.getPartitionId();
        MapService mapService = this.mapService;
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        RecordStore recordStore = mapServiceContext.getRecordStore(partitionId, this.name);
        for (int i = 0; i < keyValueSequence.size(); i += 2) {
            Data key = keyValueSequence.get(i);
            Data dataValue = keyValueSequence.get(i + 1);
            Object objectValue = mapServiceContext.toObject(dataValue);
            Object previousValue = recordStore.putFromLoad(key, objectValue);
            this.callAfterPutInterceptors(objectValue);
            this.publishEntryEvent(key, mapServiceContext.toData(previousValue), dataValue);
            this.publishWanReplicationEvent(key, dataValue, (Record)recordStore.getRecord(key));
        }
    }

    private void callAfterPutInterceptors(Object value) {
        this.mapService.getMapServiceContext().interceptAfterPut(this.name, value);
    }

    private void publishEntryEvent(Data key, Data previousValue, Data newValue) {
        EntryEventType eventType = previousValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, key, previousValue, newValue);
    }

    private void publishWanReplicationEvent(Data key, Data value, Record record) {
        if (record == null) {
            return;
        }
        if (this.mapContainer.isWanReplicationEnabled()) {
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, value, record);
            MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
        }
    }

    @Override
    public void afterRun() throws Exception {
        List<Data> keyValueSequence = this.keyValueSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        int size = keyValueSequence.size();
        ArrayList<Data> dataKeys = new ArrayList<Data>(size / 2);
        for (int i = 0; i < size; i += 2) {
            Data key = keyValueSequence.get(i);
            dataKeys.add(key);
        }
        NearCacheProvider nearCacheProvider = this.mapService.getMapServiceContext().getNearCacheProvider();
        nearCacheProvider.invalidateNearCache(this.name, dataKeys);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return !this.keyValueSequence.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutFromLoadAllBackupOperation(this.name, this.keyValueSequence);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        List<Data> keyValueSequence = this.keyValueSequence;
        int size = keyValueSequence.size();
        out.writeInt(size);
        for (Data data : keyValueSequence) {
            out.writeData(data);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size < 1) {
            this.keyValueSequence = Collections.emptyList();
        } else {
            ArrayList<Data> tmpKeyValueSequence = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = in.readData();
                tmpKeyValueSequence.add(data);
            }
            this.keyValueSequence = tmpKeyValueSequence;
        }
    }
}

