/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutAllBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PutAllOperation
extends MapOperation
implements PartitionAwareOperation,
BackupAwareOperation,
MutatingOperation {
    private MapEntries mapEntries;
    private boolean initialLoad;
    private List<Map.Entry<Data, Data>> backupEntrySet;
    private List<RecordInfo> backupRecordInfos;
    private transient RecordStore recordStore;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, MapEntries mapEntries) {
        super(name);
        this.mapEntries = mapEntries;
    }

    public PutAllOperation(String name, MapEntries mapEntries, boolean initialLoad) {
        super(name);
        this.mapEntries = mapEntries;
        this.initialLoad = initialLoad;
    }

    @Override
    public void run() {
        this.backupRecordInfos = new ArrayList<RecordInfo>();
        this.backupEntrySet = new ArrayList<Map.Entry<Data, Data>>();
        int partitionId = this.getPartitionId();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        RecordStore recordStore = this.recordStore = mapServiceContext.getRecordStore(partitionId, this.name);
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        HashSet<Data> keysToInvalidate = new HashSet<Data>();
        for (Map.Entry<Data, Data> entry : this.mapEntries) {
            this.put(partitionId, mapServiceContext, recordStore, partitionService, keysToInvalidate, entry);
        }
        this.invalidateNearCaches(keysToInvalidate);
    }

    private void put(int partitionId, MapServiceContext mapServiceContext, RecordStore recordStore, InternalPartitionService partitionService, Set<Data> keysToInvalidate, Map.Entry<Data, Data> entry) {
        Data dataKey = entry.getKey();
        Data dataValue = entry.getValue();
        if (partitionId != partitionService.getPartitionId(dataKey)) {
            return;
        }
        Data dataOldValue = null;
        if (this.initialLoad) {
            recordStore.putFromLoad(dataKey, dataValue, -1L);
        } else {
            dataOldValue = mapServiceContext.toData(recordStore.put(dataKey, dataValue, -1L));
        }
        mapServiceContext.interceptAfterPut(this.name, dataValue);
        EntryEventType eventType = dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, dataOldValue, dataValue);
        keysToInvalidate.add(dataKey);
        Object record = recordStore.getRecordOrNull(dataKey);
        if (record == null) {
            return;
        }
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            Data dataValueAsData = mapServiceContext.toData(dataValue);
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(dataKey, dataValueAsData, record);
            mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
        }
        this.backupEntrySet.add(entry);
        RecordInfo replicationInfo = Records.buildRecordInfo(recordStore.getRecord(dataKey));
        this.backupRecordInfos.add(replicationInfo);
        this.evict();
    }

    protected final void invalidateNearCaches(Set<Data> keys) {
        NearCacheProvider nearCacheProvider = this.mapService.getMapServiceContext().getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(this.name)) {
            nearCacheProvider.invalidateAllNearCaches(this.name, keys);
        }
    }

    protected void evict() {
        long now = Clock.currentTimeMillis();
        this.recordStore.evictEntries(now);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupEntrySet.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.backupEntrySet, this.backupRecordInfos);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mapEntries);
        out.writeBoolean(this.initialLoad);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapEntries = (MapEntries)in.readObject();
        this.initialLoad = in.readBoolean();
    }
}

