/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutAllBackupOperation
extends MapOperation
implements PartitionAwareOperation,
BackupOperation,
MutatingOperation {
    private List<Map.Entry<Data, Data>> entries;
    private List<RecordInfo> recordInfos;
    private RecordStore recordStore;

    public PutAllBackupOperation(String name, List<Map.Entry<Data, Data>> entries, List<RecordInfo> recordInfos) {
        super(name);
        this.entries = entries;
        this.recordInfos = recordInfos;
    }

    public PutAllBackupOperation() {
    }

    @Override
    public void run() {
        int partitionId = this.getPartitionId();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher eventPublisher = mapServiceContext.getMapEventPublisher();
        this.recordStore = mapServiceContext.getRecordStore(partitionId, this.name);
        boolean wanEnabled = this.mapContainer.isWanReplicationEnabled();
        for (int i = 0; i < this.entries.size(); ++i) {
            RecordInfo recordInfo = this.recordInfos.get(i);
            Map.Entry<Data, Data> entry = this.entries.get(i);
            Object record = this.recordStore.putBackup(entry.getKey(), entry.getValue());
            Records.applyRecordInfo(record, recordInfo);
            if (!wanEnabled) continue;
            Data dataValueAsData = mapServiceContext.toData(entry.getValue());
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(entry.getKey(), dataValueAsData, record);
            eventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
        }
    }

    @Override
    public Object getResponse() {
        return this.entries;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int size = this.entries.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Map.Entry<Data, Data> entry = this.entries.get(i);
            out.writeData(entry.getKey());
            out.writeData(entry.getValue());
            this.recordInfos.get(i).writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        this.recordInfos = new ArrayList<RecordInfo>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            AbstractMap.SimpleImmutableEntry<Data, Data> entry = new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value);
            this.entries.add(entry);
            RecordInfo recordInfo = new RecordInfo();
            recordInfo.readData(in);
            this.recordInfos.add(recordInfo);
        }
    }
}

