/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapKeySet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.Set;

public class NearCacheKeySetInvalidationOperation
extends AbstractOperation
implements MutatingOperation {
    private MapService mapService;
    private MapKeySet mapKeySet;
    private String mapName;

    public NearCacheKeySetInvalidationOperation() {
    }

    public NearCacheKeySetInvalidationOperation(String mapName, Set<Data> keys) {
        this.mapKeySet = new MapKeySet(keys);
        this.mapName = mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        if (mapServiceContext.getMapContainer(this.mapName).isNearCacheEnabled()) {
            NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
            nearCacheProvider.invalidateNearCache(this.mapName, this.mapKeySet.getKeySet());
        } else {
            this.getLogger().warning("Cache clear operation has been accepted while near cache is not enabled for " + this.mapName + " map. Possible configuration conflict among nodes.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        this.mapKeySet.writeData(out);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.mapKeySet = new MapKeySet();
        this.mapKeySet.readData(in);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.mapName);
    }
}

