/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapPartitionDestroyBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class MapPartitionDestroyOperation
extends Operation
implements PartitionAwareOperation,
BackupAwareOperation {
    private final PartitionContainer partitionContainer;
    private final String mapName;
    private int totalBackupCount;

    public MapPartitionDestroyOperation(PartitionContainer partitionContainer, String mapName) {
        this.partitionContainer = partitionContainer;
        this.mapName = mapName;
    }

    @Override
    public void beforeRun() throws Exception {
        MapService service = (MapService)this.getService();
        MapContainer mapContainer = service.getMapServiceContext().getMapContainer(this.mapName);
        this.totalBackupCount = mapContainer.getTotalBackupCount();
    }

    @Override
    public void run() throws Exception {
        this.partitionContainer.destroyMap(this.mapName);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.partitionContainer.getPartitionId();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public int getSyncBackupCount() {
        return this.totalBackupCount;
    }

    @Override
    public int getAsyncBackupCount() {
        return 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new MapPartitionDestroyBackupOperation(this.mapName, this.getPartitionId());
    }
}

