/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class MapPartitionDestroyBackupOperation
extends AbstractOperation
implements BackupOperation {
    private String mapName;

    public MapPartitionDestroyBackupOperation(String mapName, int partitionId) {
        this.setPartitionId(partitionId);
        this.mapName = mapName;
    }

    public MapPartitionDestroyBackupOperation() {
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        PartitionContainer container = mapServiceContext.getPartitionContainer(this.getPartitionId());
        container.destroyMap(this.mapName);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
    }
}

