/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class InvalidateNearCacheOperation
extends AbstractOperation
implements MutatingOperation {
    private Data key;
    private String mapName;

    public InvalidateNearCacheOperation(String mapName, Data key) {
        this.key = key;
        this.mapName = mapName;
    }

    public InvalidateNearCacheOperation() {
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        if (mapServiceContext.getMapContainer(this.mapName).isNearCacheEnabled()) {
            mapServiceContext.getNearCacheProvider().invalidateNearCache(this.mapName, this.key);
        } else {
            this.getLogger().warning("Cache clear operation has been accepted while near cache is not enabled for " + this.mapName + " map. Possible configuration conflict among nodes.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.key = in.readData();
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeData(this.key);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.mapName);
    }
}

