/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.ClearBackupOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;

public class ClearOperation
extends MapOperation
implements BackupAwareOperation,
PartitionAwareOperation,
MutatingOperation {
    boolean shouldBackup = true;
    private int numberOfClearedEntries;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        mapServiceContext.getNearCacheProvider().clearNearCache(this.name);
        RecordStore recordStore = mapServiceContext.getExistingRecordStore(this.getPartitionId(), this.name);
        if (recordStore == null) {
            this.shouldBackup = false;
            return;
        }
        this.numberOfClearedEntries = recordStore.clear();
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        this.hintMapEvent();
    }

    private void hintMapEvent() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.hintMapEvent(this.getCallerAddress(), this.name, EntryEventType.CLEAR_ALL, this.numberOfClearedEntries, this.getPartitionId());
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public Object getResponse() {
        return this.numberOfClearedEntries;
    }

    @Override
    public Operation getBackupOperation() {
        ClearBackupOperation clearBackupOperation = new ClearBackupOperation(this.name);
        clearBackupOperation.setServiceName("hz:impl:mapService");
        return clearBackupOperation;
    }
}

