/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

abstract class AbstractMultipleEntryBackupOperation
extends AbstractMultipleEntryOperation {
    protected AbstractMultipleEntryBackupOperation() {
    }

    protected AbstractMultipleEntryBackupOperation(String name, EntryProcessor entryProcessor) {
        super(name, entryProcessor);
    }

    protected AbstractMultipleEntryBackupOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    public void afterRun() throws Exception {
        this.publishWanReplicationEventBackups();
    }

    protected void publishWanReplicationEventBackups() {
        for (AbstractMultipleEntryOperation.WanEventWrapper wanEventWrapper : this.wanEventList) {
            this.publishWanReplicationEventBackup(wanEventWrapper.getKey(), wanEventWrapper.getValue(), wanEventWrapper.getEventType());
        }
    }

    protected void publishWanReplicationEventBackup(Data key, Object value, EntryEventType eventType) {
        if (this.mapContainer.isWanReplicationEnabled()) {
            MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                mapEventPublisher.publishWanReplicationRemoveBackup(this.name, key, this.getNow());
                this.wanEventList.add(new AbstractMultipleEntryOperation.WanEventWrapper(key, null, EntryEventType.REMOVED));
            } else {
                Object record = this.recordStore.getRecord(key);
                if (record != null) {
                    Data dataValueAsData = this.toData(value);
                    EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, dataValueAsData, record);
                    mapEventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
                    this.wanEventList.add(new AbstractMultipleEntryOperation.WanEventWrapper(key, value, EntryEventType.UPDATED));
                }
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.wanEventList.size());
        for (AbstractMultipleEntryOperation.WanEventWrapper wanEventWrapper : this.wanEventList) {
            out.writeData(wanEventWrapper.getKey());
            out.writeObject(wanEventWrapper.getValue());
            out.writeInt(wanEventWrapper.getEventType().getType());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Object value = in.readObject();
            EntryEventType entryEventType = EntryEventType.getByType(in.readInt());
            this.wanEventList.add(new AbstractMultipleEntryOperation.WanEventWrapper(key, value, entryEventType));
        }
    }
}

