/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.nearcache.NearCacheImpl;
import com.hazelcast.map.impl.operation.InvalidateNearCacheOperation;
import com.hazelcast.map.impl.operation.NearCacheKeySetInvalidationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NearCacheProvider {
    protected final ConcurrentMap<String, NearCache> nearCacheMap = new ConcurrentHashMap<String, NearCache>();
    protected final ConstructorFunction<String, NearCache> nearCacheConstructor = new ConstructorFunction<String, NearCache>(){

        @Override
        public NearCache createNew(String mapName) {
            MapContainer mapContainer = NearCacheProvider.this.mapServiceContext.getMapContainer(mapName);
            SizeEstimator nearCacheSizeEstimator = mapContainer.getNearCacheSizeEstimator();
            NearCacheImpl nearCache = new NearCacheImpl(mapName, NearCacheProvider.this.nodeEngine);
            nearCache.setNearCacheSizeEstimator(nearCacheSizeEstimator);
            return nearCache;
        }
    };
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    public NearCacheProvider(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = nodeEngine;
    }

    public NearCache getOrCreateNearCache(String mapName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.nearCacheMap, mapName, this.nearCacheConstructor);
    }

    public void clear() {
        for (NearCache nearCache : this.nearCacheMap.values()) {
            nearCache.clear();
        }
        this.nearCacheMap.clear();
    }

    public void remove(String mapName) {
        NearCache nearCache = (NearCache)this.nearCacheMap.remove(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    public void invalidateNearCache(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getOrCreateNearCache(mapName);
        nearCache.remove(key);
    }

    public void invalidateNearCache(String mapName, Collection<Data> keys) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getOrCreateNearCache(mapName);
        for (Data key : keys) {
            nearCache.remove(key);
        }
    }

    public void clearNearCache(String mapName) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getOrCreateNearCache(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    public void invalidateAllNearCaches(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            try {
                if (member.localMember()) continue;
                Operation operation = new InvalidateNearCacheOperation(mapName, key).setServiceName("hz:impl:mapService");
                this.nodeEngine.getOperationService().send(operation, member.getAddress());
            }
            catch (Throwable throwable) {
                throw new HazelcastException(throwable);
            }
        }
        this.invalidateNearCache(mapName, key);
    }

    public boolean isNearCacheAndInvalidationEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.isNearCacheEnabled() && mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange();
    }

    public boolean isNearCacheEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.isNearCacheEnabled();
    }

    public void invalidateAllNearCaches(String mapName, Set<Data> keys) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Operation operation = new NearCacheKeySetInvalidationOperation(mapName, keys).setServiceName("hz:impl:mapService");
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            try {
                if (member.localMember()) continue;
                this.nodeEngine.getOperationService().send(operation, member.getAddress());
            }
            catch (Throwable throwable) {
                this.nodeEngine.getLogger(this.getClass()).warning(throwable);
            }
        }
        for (Data key : keys) {
            this.invalidateNearCache(mapName, key);
        }
    }

    public Object getFromNearCache(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return null;
        }
        NearCache nearCache = this.getOrCreateNearCache(mapName);
        return nearCache.get(key);
    }
}

